/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationDataVaultProviderAWSSecretsManager;
import au.com.nemmco.Util.ApplicationDataVaultProviderAzureKeyVault;
import au.com.nemmco.Util.ApplicationDataVaultProviderGoogleSecretsManager;
import au.com.nemmco.Util.ApplicationDataVaultProviderInt;
import au.com.nemmco.Util.ApplicationDataVaultProviderPropertiesFile;
import au.com.nemmco.Util.DataVault;
import au.com.nemmco.Util.DataVaultConfig;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataVaultManager {
    private static Logger logger = LoggerFactory.getLogger(ApplicationDataVaultManager.class);
    private Map<String, Class> itsProviders = new HashMap<String, Class>();
    private Map<String, ApplicationDataVaultProviderInt> dataVaults = new HashMap<String, ApplicationDataVaultProviderInt>();

    private ApplicationDataVaultManager() {
        this.registerProvider(new ApplicationDataVaultProviderPropertiesFile());
        this.registerProvider(new ApplicationDataVaultProviderAzureKeyVault());
        this.registerProvider(new ApplicationDataVaultProviderGoogleSecretsManager());
        this.registerProvider(new ApplicationDataVaultProviderAWSSecretsManager());
    }

    public static ApplicationDataVaultManager getInstance() {
        return SingletonHolder.instance;
    }

    public void registerProvider(ApplicationDataVaultProviderInt applicationDataVaultProviderInt) {
        this.itsProviders.put(applicationDataVaultProviderInt.getId().toUpperCase(), applicationDataVaultProviderInt.getClass());
    }

    public void configure(DataVaultConfig dataVaultConfig) throws Exception {
        if (dataVaultConfig != null && dataVaultConfig.DataVault != null) {
            for (DataVault dataVault : dataVaultConfig.DataVault) {
                if (Util.isBlank(dataVault.Name)) {
                    throw new Exception("Detected data vault with missing name, provider=" + dataVault.Provider + ", ref=" + dataVault.Reference);
                }
                if (Util.isBlank(dataVault.Provider)) {
                    throw new Exception("Detected data vault with missing provider, name=" + dataVault.Name + ", ref=" + dataVault.Reference);
                }
                if (Util.isBlank(dataVault.Reference)) {
                    throw new Exception("Detected data vault with missing reference, name=" + dataVault.Name + ", provider=" + dataVault.Provider);
                }
                String string = dataVault.Provider.toUpperCase().trim();
                Class clazz = this.itsProviders.get(string);
                if (clazz == null) {
                    throw new Exception("Unsupported data vault provider " + string + " detected");
                }
                ApplicationDataVaultProviderInt applicationDataVaultProviderInt = (ApplicationDataVaultProviderInt)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                applicationDataVaultProviderInt.initialise(dataVault);
                this.dataVaults.put(dataVault.Name.toUpperCase().trim(), applicationDataVaultProviderInt);
                Util_Logger.info(logger, "Configured data vault " + dataVault.Name + " with provider " + string + ", reference " + dataVault.Reference);
            }
        }
    }

    public String getValue(String string) {
        String string2 = null;
        String[] stringArray = Util.getColumns(string, ':');
        if (stringArray != null) {
            if (stringArray.length == 2) {
                String string3 = Util.noNull(stringArray[0]).trim().toUpperCase();
                ApplicationDataVaultProviderInt applicationDataVaultProviderInt = this.dataVaults.get(string3);
                if (applicationDataVaultProviderInt != null) {
                    string2 = applicationDataVaultProviderInt.getValue(stringArray[1]);
                } else {
                    Util_Logger.errorNoRaise(logger, "Detected unknown vault name " + string3 + " referenced in key " + string);
                }
            } else {
                Util_Logger.errorNoRaise(logger, "Detected invalid data vault reference " + string + ", expected {vault_name}:{key}");
            }
        }
        return string2;
    }

    public boolean isEnabled() {
        return this.dataVaults.size() > 0;
    }

    public static DataVaultConfig loadConfigFromProperties(Properties properties) {
        String[] stringArray;
        DataVaultConfig dataVaultConfig = new DataVaultConfig();
        String string = properties.getProperty("data_vault_configurations");
        if (!Util.isBlank(string) && (stringArray = Util.getColumns(string, ',')) != null) {
            for (String string2 : stringArray) {
                if (Util.isBlank(string2)) continue;
                DataVault dataVault = new DataVault();
                dataVault.Name = string2;
                dataVault.Provider = properties.getProperty("data_vault_" + string2 + "_provider");
                dataVault.Reference = properties.getProperty("data_vault_" + string2 + "_reference");
                dataVault.AuthMethod = properties.getProperty("data_vault_" + string2 + "_auth_method");
                dataVault.ServiceContext = properties.getProperty("data_vault_" + string2 + "_service_context");
                dataVault.API_Key = properties.getProperty("data_vault_" + string2 + "_api_key");
                dataVaultConfig.DataVault.add(dataVault);
            }
        }
        return dataVaultConfig;
    }

    private static class SingletonHolder {
        private static ApplicationDataVaultManager instance = new ApplicationDataVaultManager();

        private SingletonHolder() {
        }
    }
}

