/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.AlertConfig;
import au.com.nemmco.Util.AlertManager;
import au.com.nemmco.Util.AppConfiguration;
import au.com.nemmco.Util.ApplicationDataVaultManager;
import au.com.nemmco.Util.ApplicationExtensionInt;
import au.com.nemmco.Util.ApplicationInt;
import au.com.nemmco.Util.ApplicationManagerStartupOptions;
import au.com.nemmco.Util.ApplicationShutdown;
import au.com.nemmco.Util.AuthenticationConfig;
import au.com.nemmco.Util.AuthenticationManager;
import au.com.nemmco.Util.ConfigurationValueResolver;
import au.com.nemmco.Util.DataVault;
import au.com.nemmco.Util.DataVaultConfig;
import au.com.nemmco.Util.DatabaseConfig;
import au.com.nemmco.Util.DbManager;
import au.com.nemmco.Util.DistributedMessagingConfig;
import au.com.nemmco.Util.DistributedMessagingManager;
import au.com.nemmco.Util.FilesystemManager;
import au.com.nemmco.Util.FilesystemMonitor;
import au.com.nemmco.Util.FilesystemMonitorConfig;
import au.com.nemmco.Util.JobSchedulerManager;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebAPIAppAbout;
import au.com.nemmco.Util.WebAPIAppConfiguration;
import au.com.nemmco.Util.WebAPIAppStatus;
import au.com.nemmco.Util.WebAPIAuthentication;
import au.com.nemmco.Util.WebAPIAuthenticationRoles;
import au.com.nemmco.Util.WebAPIAuthenticationUsers;
import au.com.nemmco.Util.WebAPIAuthorisation;
import au.com.nemmco.Util.WebAPIDatabaseStatus;
import au.com.nemmco.Util.WebAPIServerStatus;
import au.com.nemmco.Util.WebAPIServicesCatalog;
import au.com.nemmco.Util.WebAccessEnum;
import au.com.nemmco.Util.WebServer;
import au.com.nemmco.Util.WebServerConfig;
import au.com.nemmco.Util.WebServerConfigIPAddress;
import au.com.nemmco.Util.XProperties;
import au.com.nemmco.Util.XmlUtilities;
import au.com.nemmco.Util.threadMonitor;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(ApplicationManager.class);
    private ApplicationInt itsApplication;
    private List<ApplicationExtensionInt> itsExtensions;
    private Date itsStartDate = new Date();
    private String itsAppName;
    private UUID itsUUID = UUID.randomUUID();

    private ApplicationManager() {
        this.itsExtensions = new ArrayList<ApplicationExtensionInt>();
    }

    public static ApplicationManager getInstance() {
        return SingletonHolder.instance;
    }

    public ApplicationManagerStartupOptions buildStartOptions() {
        return new ApplicationManagerStartupOptions();
    }

    protected Date getStartDate() {
        return this.itsStartDate;
    }

    public UUID getUUID() {
        return this.itsUUID;
    }

    protected List<ApplicationExtensionInt> getExtensions() {
        return this.itsExtensions;
    }

    public synchronized void init(String string, String string2, String string3, Class clazz) throws Exception {
        this.init(string, string2, string3, clazz, this.buildStartOptions().startDatabase().startWebServer().startDistributedMessaging().startFileSystemManager());
    }

    public void init(String string, String string2, String string3, Class clazz, ApplicationManagerStartupOptions applicationManagerStartupOptions) throws Exception {
        ApplicationManager.initPreConfig(string2);
        Util_Logger.info(logger, "Starting " + string2 + " v" + string3 + " with configuration file " + string);
        this.itsAppName = string2;
        XProperties xProperties = new XProperties();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        xProperties.load(inputStream);
        AppConfiguration appConfiguration = new AppConfiguration();
        appConfiguration.DataVaults = ApplicationDataVaultManager.loadConfigFromProperties(xProperties);
        ApplicationDataVaultManager applicationDataVaultManager = ApplicationDataVaultManager.getInstance();
        applicationDataVaultManager.configure(appConfiguration.DataVaults);
        appConfiguration.AppName = string2;
        appConfiguration.AppVersion = string3;
        appConfiguration.AppClass = clazz;
        appConfiguration.Alert = AlertManager.loadConfigFromProperties(xProperties);
        if (applicationManagerStartupOptions.getStartWebServer()) {
            appConfiguration.WebServer = WebServer.loadConfigFromProperties(xProperties);
        }
        if (applicationManagerStartupOptions.getStartDatabase()) {
            appConfiguration.Database = DbManager.loadConfigFromProperties(xProperties);
        }
        appConfiguration.FilesystemMonitor = FilesystemManager.loadConfigFromProperties(xProperties);
        appConfiguration.DistributedMessaging = DistributedMessagingManager.loadConfigFromProperties(xProperties);
        appConfiguration.AppExtensionClass = Util.getProperty((Properties)xProperties, "application_extension_class", null);
        this.initPostConfig(appConfiguration, applicationManagerStartupOptions);
    }

    private AppConfiguration loadConfig(Class clazz, String string, Class clazz2, List<Class> list) throws Exception {
        AppConfiguration appConfiguration = (AppConfiguration)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        XStream xStream = XmlUtilities.getConverter();
        xStream.processAnnotations(AppConfiguration.class);
        xStream.processAnnotations(WebServerConfig.class);
        xStream.processAnnotations(WebServerConfigIPAddress.class);
        xStream.processAnnotations(WebAccessEnum.class);
        xStream.processAnnotations(AlertConfig.class);
        xStream.processAnnotations(DatabaseConfig.class);
        xStream.processAnnotations(AuthenticationConfig.class);
        xStream.processAnnotations(FilesystemMonitorConfig.class);
        xStream.processAnnotations(FilesystemMonitor.class);
        xStream.processAnnotations(DataVaultConfig.class);
        xStream.processAnnotations(DataVault.class);
        xStream.processAnnotations(DistributedMessagingConfig.class);
        if (list != null) {
            for (Class object2 : list) {
                xStream.processAnnotations(object2);
            }
        }
        final ConfigurationValueResolver configurationValueResolver = new ConfigurationValueResolver();
        xStream.unmarshal((HierarchicalStreamReader)new DomReader(document){

            public String getValue() {
                String string = super.getValue();
                String string2 = configurationValueResolver.resolveValue(string, false);
                return string2;
            }
        }, (Object)appConfiguration);
        ApplicationDataVaultManager applicationDataVaultManager = ApplicationDataVaultManager.getInstance();
        applicationDataVaultManager.configure(appConfiguration.DataVaults);
        if (applicationDataVaultManager.isEnabled()) {
            xStream.unmarshal((HierarchicalStreamReader)new DomReader(document){

                public String getValue() {
                    String string = super.getValue();
                    String string2 = configurationValueResolver.resolveValue(string, true);
                    return string2;
                }
            }, (Object)appConfiguration);
        }
        appConfiguration.applyDefaults();
        return appConfiguration;
    }

    public AppConfiguration init(String string, String string2, Class clazz, String string3, Class clazz2, List<Class> list, ApplicationManagerStartupOptions applicationManagerStartupOptions) throws Exception {
        ApplicationManager.initPreConfig(string);
        Util_Logger.info(logger, "Starting " + string + " v" + string2 + " with configuration file " + string3);
        this.itsAppName = string;
        AppConfiguration appConfiguration = this.loadConfig(clazz, string3, clazz2, list);
        appConfiguration.AppName = string;
        appConfiguration.AppVersion = string2;
        appConfiguration.AppClass = clazz;
        this.initPostConfig(appConfiguration, applicationManagerStartupOptions);
        return appConfiguration;
    }

    private static void initPreConfig(String string) throws Exception {
        String string2 = InetAddress.getLocalHost().getHostName();
        System.setProperty("hostname", string2);
        System.setProperty("app_name", string);
        TimeZone timeZone = TimeZone.getTimeZone("Australia/Brisbane");
        TimeZone.setDefault(timeZone);
        Locale.setDefault(Locale.ENGLISH);
    }

    private void initPostConfig(AppConfiguration appConfiguration, ApplicationManagerStartupOptions applicationManagerStartupOptions) throws Exception {
        Object object;
        Object object2;
        if (!Util.isBlank(appConfiguration.AppExtensionClass)) {
            for (Object object3 : object2 = Util.getColumns(appConfiguration.AppExtensionClass, ',')) {
                if (Util.isBlank((String)object3)) continue;
                Class<?> clazz = Class.forName((String)object3);
                ApplicationExtensionInt applicationExtensionInt = (ApplicationExtensionInt)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.itsExtensions.add(applicationExtensionInt);
                Util_Logger.info(logger, "Added extension library " + applicationExtensionInt.name() + " " + applicationExtensionInt.version());
            }
        }
        if (applicationManagerStartupOptions.getStartDatabase()) {
            DbManager.initDbPool(appConfiguration);
        }
        object2 = threadMonitor.getInstance();
        ((threadMonitor)object2).setAppDetails(appConfiguration);
        AlertManager.configureAlert(appConfiguration);
        if (applicationManagerStartupOptions.getStartAuthenticationManager() && appConfiguration.Authentication != null) {
            AuthenticationManager.getInstance().configure(appConfiguration.Authentication);
        }
        if (applicationManagerStartupOptions.getStartFileSystemManager() && appConfiguration.FilesystemMonitor != null) {
            FilesystemManager.getInstance().configure(appConfiguration.FilesystemMonitor);
        }
        if (applicationManagerStartupOptions.getStartDistributedMessaging() && appConfiguration.DistributedMessaging != null) {
            object = DistributedMessagingManager.getInstance();
            ((DistributedMessagingManager)object).init(appConfiguration.DistributedMessaging);
            ((DistributedMessagingManager)object).start();
        }
        if (applicationManagerStartupOptions.getStartWebServer() && appConfiguration.WebServer != null) {
            object = WebServer.getInstance();
            ((WebServer)object).init(appConfiguration.WebServer);
            ((WebServer)object).addHandler(WebAPIServerStatus.class);
            if (appConfiguration.WebServer.WebServiceCatalogEnable.booleanValue()) {
                ((WebServer)object).addHandler(WebAPIServicesCatalog.class);
            }
            if (applicationManagerStartupOptions.getStartDatabase()) {
                ((WebServer)object).addHandler(WebAPIDatabaseStatus.class);
            }
            ((WebServer)object).addHandler(WebAPIAppStatus.class);
            ((WebServer)object).addHandler(WebAPIAppConfiguration.class);
            ((WebServer)object).addHandler(WebAPIAppAbout.class);
            if (appConfiguration.Authentication != null) {
                ((WebServer)object).addHandler(WebAPIAuthentication.class);
                ((WebServer)object).addHandler(WebAPIAuthorisation.class);
                ((WebServer)object).addHandler(WebAPIAuthenticationRoles.class);
                ((WebServer)object).addHandler(WebAPIAuthenticationUsers.class);
            }
            ((WebServer)object).start();
        }
        if (this.itsExtensions != null) {
            for (ApplicationExtensionInt applicationExtensionInt : this.itsExtensions) {
                try {
                    applicationExtensionInt.initialise();
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error initialising application extension " + applicationExtensionInt.name() + ": " + exception.getMessage(), exception);
                }
            }
        }
    }

    public void register(ApplicationInt applicationInt) {
        this.itsApplication = applicationInt;
        if (this.itsExtensions != null) {
            for (ApplicationExtensionInt applicationExtensionInt : this.itsExtensions) {
                try {
                    applicationExtensionInt.start();
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error starting application extension " + applicationExtensionInt.name() + ": " + exception.getMessage(), exception);
                }
            }
        }
    }

    public void registerWithShutdown(ApplicationInt applicationInt) {
        this.register(applicationInt);
        new ApplicationShutdown();
    }

    public ApplicationInt getApplication() {
        return this.itsApplication;
    }

    public Properties getConfiguration() {
        return this.itsApplication.getConfiguration();
    }

    public void shutdown(ApplicationInt applicationInt) {
        Util_Logger.info(logger, "Shutting down " + this.itsAppName + " service");
        if (this.itsExtensions != null) {
            for (ApplicationExtensionInt applicationExtensionInt : this.itsExtensions) {
                try {
                    applicationExtensionInt.stop();
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error stopping application extension " + applicationExtensionInt.name() + ": " + exception.getMessage(), exception);
                }
            }
        }
        threadMonitor.getInstance().stop();
        WebServer.getInstance().stop();
        JobSchedulerManager.getInstance().stop();
        if (applicationInt != null) {
            applicationInt.stop();
        }
        threadMonitor.getInstance().wakeUpThreads();
        if (applicationInt != null) {
            applicationInt.finaliseShutdown();
        }
        DistributedMessagingManager.getInstance().stop();
        Util_Logger.info(logger, this.itsAppName + " stopped");
    }

    public void shutdown() {
        this.shutdown(this.itsApplication);
    }

    private static class SingletonHolder {
        private static ApplicationManager instance = new ApplicationManager();

        private SingletonHolder() {
        }
    }
}

