/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.AuthenticationConfig;
import au.com.nemmco.Util.AuthenticationToken;
import au.com.nemmco.Util.AuthorisationActionEnum;
import au.com.nemmco.Util.AuthorisationProviderInt;
import au.com.nemmco.Util.IdentityPrincipal;
import au.com.nemmco.Util.IdentityProviderInt;
import au.com.nemmco.Util.IdentityRole;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationManager {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationManager.class);
    private Map<String, AuthenticationToken> Tokens = new ConcurrentHashMap<String, AuthenticationToken>();
    private SecureRandom random = new SecureRandom();
    private int MaxTokenLifeMins;
    private int TokenExpiryMins;
    private int TokenEvictionCycleMins;
    private IdentityProviderInt IdentityProvider;
    private AuthorisationProviderInt AuthorisationProvider;
    private String AdminRole;

    private AuthenticationManager() {
    }

    public static AuthenticationManager getInstance() {
        return SingletonHolder.instance;
    }

    public void configure(AuthenticationConfig authenticationConfig) throws Exception {
        Util_Logger.info(logger, "Initialising authentication manager");
        this.MaxTokenLifeMins = authenticationConfig.MaxTokenLifeMins == null ? 1440 : authenticationConfig.MaxTokenLifeMins;
        this.TokenExpiryMins = authenticationConfig.TokenExpiryMins == null ? 60 : authenticationConfig.TokenExpiryMins;
        this.TokenEvictionCycleMins = authenticationConfig.TokenEvictionCycleMins == null ? 5 : authenticationConfig.TokenEvictionCycleMins;
        this.IdentityProvider = (IdentityProviderInt)Class.forName(authenticationConfig.IdentityProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.IdentityProvider.configure(authenticationConfig);
        this.AuthorisationProvider = (AuthorisationProviderInt)Class.forName(authenticationConfig.AuthorisationProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.AdminRole = authenticationConfig.AdminRole;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("AUTHENTICATION_TOKEN_MANAGER");
                thread.setDaemon(true);
                return thread;
            }
        });
        scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AuthenticationManager.getInstance().expireTokens();
            }
        }, 1L, this.TokenEvictionCycleMins, TimeUnit.MINUTES);
    }

    public boolean isEnabled() {
        return this.IdentityProvider != null;
    }

    private AuthenticationToken createToken(IdentityPrincipal identityPrincipal) {
        AuthenticationToken authenticationToken = new AuthenticationToken();
        authenticationToken.IssuedTo = identityPrincipal;
        authenticationToken.LastAccessed = authenticationToken.Created = new Date();
        authenticationToken.SessionKey = new BigInteger(128, this.random).toString(16).toUpperCase();
        this.Tokens.put(authenticationToken.SessionKey, authenticationToken);
        return authenticationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireTokens() {
        Util_Logger.info(logger, "Validating authentication token registry");
        ArrayList<AuthenticationToken> arrayList = new ArrayList<AuthenticationToken>();
        Date date = new Date();
        for (AuthenticationToken object : this.Tokens.values()) {
            Object object2 = Util.dateOffset(object.Created, this.MaxTokenLifeMins, 12);
            Date date2 = Util.dateOffset(object.LastAccessed, this.TokenExpiryMins, 12);
            if (date.after((Date)object2)) {
                Util_Logger.info(logger, "Expiring token [" + object.SessionKey + "] issued to user " + object.IssuedTo.User_Id + ", maximum token life exceeded");
                arrayList.add(object);
                continue;
            }
            if (!date.after(date2)) continue;
            Util_Logger.info(logger, "Expiring token [" + object.SessionKey + "] issued to user " + object.IssuedTo.User_Id + ", token inactivity");
            arrayList.add(object);
        }
        Map<String, AuthenticationToken> map = this.Tokens;
        synchronized (map) {
            for (Object object2 : arrayList) {
                this.Tokens.remove(((AuthenticationToken)object2).SessionKey);
            }
        }
    }

    public boolean validateToken(String string) throws Exception {
        boolean bl = false;
        AuthenticationToken authenticationToken = this.Tokens.get(string);
        if (authenticationToken == null) {
            throw new Exception("Invalid token");
        }
        authenticationToken.LastAccessed = new Date();
        bl = true;
        return bl;
    }

    private AuthenticationToken getTokenDetail(String string) throws Exception {
        return this.Tokens.get(string);
    }

    public void updatePassword(String string, String string2) throws Exception {
        this.IdentityProvider.updatePassword(string, string2);
    }

    public String authenticateUser(String string, String string2) throws Exception {
        Util_Logger.info(logger, "Received login request for user " + string);
        String string3 = null;
        try {
            IdentityPrincipal identityPrincipal = this.IdentityProvider.authenticateUser(string, string2);
            if (identityPrincipal != null) {
                AuthenticationToken authenticationToken = this.createToken(identityPrincipal);
                string3 = authenticationToken.SessionKey;
                Util_Logger.info(logger, "Successfully logged in user " + string + ", issued token [" + string3 + "]");
            } else {
                Util_Logger.warning(logger, "Failed login attempt for user " + string);
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error processing login attempt for user " + string + ": " + exception.getMessage(), exception);
            throw exception;
        }
        return string3;
    }

    public List<IdentityRole> getRoles() {
        return this.IdentityProvider.getRoles();
    }

    public String getProviderId() {
        return this.IdentityProvider.getId();
    }

    public void updateRoles(List<IdentityRole> list) throws Exception {
        int[] nArray = this.IdentityProvider.updateRoles(list);
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] > 0) {
                    Util_Logger.info(logger, "Updated role " + list.get((int)i2).Role_Id);
                    continue;
                }
                Util_Logger.info(logger, "Inserted role " + list.get((int)i2).Role_Id);
            }
        }
    }

    public List<IdentityPrincipal> getUsers() {
        return this.IdentityProvider.getUsers();
    }

    public void createUser(IdentityPrincipal identityPrincipal) throws Exception {
        if (identityPrincipal != null) {
            this.IdentityProvider.createUser(identityPrincipal);
            int n2 = 0;
            if (identityPrincipal.Roles != null) {
                for (IdentityRole identityRole : identityPrincipal.Roles) {
                    if (!Util.intToBoolean(identityRole.Is_Active)) continue;
                    ++n2;
                }
            }
            Util_Logger.info(logger, "Saved user " + identityPrincipal.User_Id + " [" + (Util.intToBoolean(identityPrincipal.Is_Active) ? "Active" : "Inactive") + "] with " + n2 + " active roles");
        }
    }

    private boolean checkRoles(List<String> list, AuthenticationToken authenticationToken) {
        if (authenticationToken.IssuedTo.Roles != null) {
            for (IdentityRole identityRole : authenticationToken.IssuedTo.Roles) {
                if (list == null) continue;
                for (String string : list) {
                    if (!string.equalsIgnoreCase(identityRole.Role_Id)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkAuthorisation(String string, String string2, boolean bl, String string3, AuthorisationActionEnum authorisationActionEnum) {
        boolean bl2 = false;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!bl) {
                arrayList = this.AuthorisationProvider.resolveRole(string3, authorisationActionEnum);
            }
            arrayList.add(this.AdminRole);
            AuthenticationToken authenticationToken = this.getTokenDetail(string);
            if (authenticationToken != null && !(bl2 = this.checkRoles(arrayList, authenticationToken))) {
                Util_Logger.warning(logger, "Denied access to [" + authenticationToken.IssuedTo.User_Id + "] to resource [" + string2 + "]");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Unable to perform authorisation: " + exception.getMessage(), exception);
        }
        return bl2;
    }

    public String getAuthorisedContext(String string) throws Exception {
        AuthenticationToken authenticationToken = this.getTokenDetail(string);
        return this.AuthorisationProvider.resolveRolesToContext(string, authenticationToken.IssuedTo.User_Id, this.AdminRole, authenticationToken.IssuedTo.Roles);
    }

    private static class SingletonHolder {
        private static AuthenticationManager instance = new AuthenticationManager();

        private SingletonHolder() {
        }
    }
}

