/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.Crypt;
import au.com.nemmco.Util.CryptProviderInt;
import au.com.nemmco.Util.Util_Logger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptProviderDES
implements CryptProviderInt {
    private static Logger logger = LoggerFactory.getLogger(Crypt.class);
    private String seed;
    private Cipher desCipher;
    private static final String CIPHER = "DES/ECB/NoPadding";
    private static final String ALGO = "DES";

    public CryptProviderDES(String string) {
        this.seed = string;
    }

    private SecretKey getKey(String string) throws Exception {
        byte[] byArray = new byte[]{};
        DESKeySpec dESKeySpec = null;
        SecretKeyFactory secretKeyFactory = null;
        SecretKey secretKey = null;
        try {
            Hex hex = new Hex();
            try {
                byArray = (byte[])hex.decode(string);
            }
            catch (DecoderException decoderException) {
                Util_Logger.error(logger, "Error decoding key seed to Hex byte array: " + decoderException.getMessage(), decoderException);
            }
            dESKeySpec = new DESKeySpec(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            Util_Logger.error(logger, "Error getting key spec: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        try {
            secretKeyFactory = SecretKeyFactory.getInstance(ALGO);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Util_Logger.error(logger, "Error getting key factory: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        try {
            secretKey = secretKeyFactory.generateSecret(dESKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            Util_Logger.error(logger, "Error generating key: " + invalidKeySpecException.getMessage(), invalidKeySpecException);
        }
        return secretKey;
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (this.desCipher == null) {
            this.desCipher = Cipher.getInstance(CIPHER);
        }
        return this.desCipher;
    }

    @Override
    public String encrypt(String string) throws ApplicationException {
        try {
            this.desCipher = this.getCipher();
            this.desCipher.init(1, this.getKey(this.seed));
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing encrypt: " + exception.getMessage(), exception);
        }
        return this.encrypt(this.desCipher, string);
    }

    private String encrypt(Cipher cipher, String string) {
        String string2 = null;
        if (string != null) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            byArray = string.getBytes();
            n2 = byArray.length;
            n3 = n2 / 8;
            n4 = n2 % 8;
            n5 = n3 * 8;
            if (n4 != 0) {
                n5 += 8;
            }
            byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            try {
                byArray3 = cipher.doFinal(byArray2);
                string2 = new String(new Base64().encode(byArray3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    @Override
    public String decrypt(String string) throws Exception {
        String string2 = this.decrypt(this.getKey(this.seed), string);
        return string2;
    }

    private String decrypt(SecretKey secretKey, String string) throws Exception {
        try {
            this.desCipher = this.getCipher();
            this.desCipher.init(2, secretKey);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing decrypt: " + exception.getMessage(), exception);
        }
        return this.decrypt(this.desCipher, string);
    }

    private String decrypt(Cipher cipher, String string) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string2 = null;
        if (string != null) {
            byArray = string.getBytes();
            byArray2 = cipher.doFinal(new Base64().decode(byArray));
            int n2 = byArray2.length;
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray2[i2] != 0) continue;
                n2 = i2;
                break;
            }
            string2 = new String(byArray2, 0, n2);
        }
        return string2;
    }
}

