/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import java.io.PrintWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvWriter {
    private static Logger logger = LoggerFactory.getLogger(CsvWriter.class);
    static final boolean debugging = false;
    PrintWriter pw;
    int quoteLevel;
    char separator;
    private char quote;
    boolean wasPreviousField = false;

    public CsvWriter(Writer writer, int n2, char c2, char c3) {
        this.pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        if (this.pw == null) {
            throw new IllegalArgumentException("invalid Writer");
        }
        this.quoteLevel = n2;
        this.separator = c2;
        this.quote = c3;
    }

    public CsvWriter(Writer writer) {
        this(writer, 1, ',', '\"');
    }

    public void put(String string) {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        if (string == null) {
            string = "";
        }
        if (this.wasPreviousField) {
            this.pw.print(this.separator);
        }
        if ((string = string.trim()).indexOf(this.quote) >= 0) {
            this.pw.print(this.quote);
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == this.quote) {
                    this.pw.print(this.quote);
                    this.pw.print(this.quote);
                    continue;
                }
                this.pw.print(c2);
            }
            this.pw.print(this.quote);
        } else if (this.quoteLevel == 2 || this.quoteLevel == 1 && string.indexOf(32) >= 0 || string.indexOf(this.separator) >= 0) {
            this.pw.print(this.quote);
            this.pw.print(string);
            this.pw.print(this.quote);
        } else {
            this.pw.print(string);
        }
        this.wasPreviousField = true;
    }

    public void put(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.put(stringArray[i2]);
        }
    }

    public void nl() {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVSWriter");
        }
        this.pw.println("");
        this.wasPreviousField = false;
    }

    public void flush() {
        if (this.pw != null) {
            this.pw.flush();
            this.pw = null;
        }
    }

    public void close() {
        if (this.pw != null) {
            this.pw.close();
            this.pw = null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

