/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.ObjectStreamException;

@XStreamAlias(value="Database")
public class DatabaseConfig {
    public String User;
    public String Password;
    public Boolean PasswordEncrypted;
    public String Driver;
    public String URL;
    public String DbHandler;
    public String DbDateFormat;
    public String DbTimestampFormat;
    public String JavaDateFormat = "yyyy/MM/dd HH:mm:ss";
    public String JavaTimestampFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    public String InsertMode = "safe";
    public String DbProps;
    public String DbConnInitSQL;
    public String[] DbTablespacesToReport;
    public Integer DbPoolMaxWaitForConnectionSecs;
    public Integer DbPoolMinEvictableIdleTimeSecs;
    public Integer DbPoolMinConnections;
    public Integer DbPoolMaxConnections;
    public Integer DbPoolTimeBetweenEvictionRunsSecs;

    public DatabaseConfig() {
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        if (this.PasswordEncrypted == null) {
            this.PasswordEncrypted = true;
        }
        if (this.JavaDateFormat == null) {
            this.JavaDateFormat = "yyyy/MM/dd HH:mm:ss";
        }
        if (this.JavaTimestampFormat == null) {
            this.JavaTimestampFormat = "yyyy/MM/dd HH:mm:ss.SSS";
        }
        if (this.InsertMode == null) {
            this.InsertMode = "safe";
        }
        if (this.DbPoolMaxWaitForConnectionSecs == null) {
            this.DbPoolMaxWaitForConnectionSecs = 60;
        }
        if (this.DbPoolMinEvictableIdleTimeSecs == null) {
            this.DbPoolMinEvictableIdleTimeSecs = 1800;
        }
        if (this.DbPoolMinConnections == null) {
            this.DbPoolMinConnections = 3;
        }
        if (this.DbPoolMaxConnections == null) {
            this.DbPoolMaxConnections = 15;
        }
        if (this.DbPoolTimeBetweenEvictionRunsSecs == null) {
            this.DbPoolTimeBetweenEvictionRunsSecs = 120;
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        this.setDefaultValues();
        return this;
    }
}

