/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.DatabaseConfig;
import au.com.nemmco.Util.DbConnectionPoolFactory;
import au.com.nemmco.Util.DbHandler;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Date;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConnectionPool {
    private static Logger logger = LoggerFactory.getLogger(DbConnectionPool.class);
    private volatile GenericObjectPool<Connection> itsPool;
    private Date itsPoolLastCleared;
    private int itsPoolTimeoutMins;
    private DatabaseConfig itsConfig;
    private DbConnectionPoolFactory itsFactory;
    private DbHandler itsDb;

    public DbConnectionPool(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        this.itsConfig = databaseConfig;
        try {
            Class<?> clazz = Class.forName(this.itsConfig.DbHandler);
            Constructor<?> constructor = clazz.getConstructor(DatabaseConfig.class, String.class, String.class);
            this.itsDb = (DbHandler)constructor.newInstance(this.itsConfig, string, string2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error setting up database connection pool manager " + exception.getMessage(), exception);
        }
        this.itsFactory = new DbConnectionPoolFactory(this.itsDb, string, string2){

            @Override
            public synchronized PooledObject<Connection> makeObject() throws Exception {
                PooledObject<Connection> pooledObject = super.makeObject();
                DbConnectionPool.this.logConnectionPoolState(1);
                return pooledObject;
            }

            @Override
            public void destroyObject(PooledObject<Connection> pooledObject) throws Exception {
                super.destroyObject(pooledObject);
                DbConnectionPool.this.logConnectionPoolState(0);
            }
        };
        this.createDatabaseConnectionPool();
    }

    public DbHandler getDbHandler() {
        return this.itsDb;
    }

    private void createDatabaseConnectionPool() {
        if (this.itsPool != null) {
            try {
                this.itsPool.clear();
                this.itsPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setBlockWhenExhausted(true);
        genericObjectPoolConfig.setMinIdle(this.itsConfig.DbPoolMinConnections.intValue());
        genericObjectPoolConfig.setMaxTotal(this.itsConfig.DbPoolMaxConnections.intValue());
        genericObjectPoolConfig.setTestWhileIdle(true);
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis((long)(this.itsConfig.DbPoolTimeBetweenEvictionRunsSecs * 1000));
        genericObjectPoolConfig.setMinEvictableIdleTimeMillis((long)(this.itsConfig.DbPoolMinEvictableIdleTimeSecs * 1000));
        genericObjectPoolConfig.setTestOnBorrow(true);
        genericObjectPoolConfig.setTestOnReturn(true);
        genericObjectPoolConfig.setLifo(true);
        genericObjectPoolConfig.setMaxWaitMillis((long)(this.itsConfig.DbPoolMaxWaitForConnectionSecs * 1000));
        this.itsPool = new GenericObjectPool((PooledObjectFactory)this.itsFactory);
        this.itsPool.setConfig(genericObjectPoolConfig);
        this.itsPoolLastCleared = new Date();
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            connection = (Connection)this.itsPool.borrowObject();
            Util_Logger.debug(logger, "Borrowed Database connection [" + connection.toString() + "]");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to borrow Database connection from object pool: " + exception.getMessage(), exception);
        }
        return connection;
    }

    public void returnConnection(Connection connection) {
        if (connection != null) {
            try {
                Util_Logger.debug(logger, "Returned Database connection [" + connection.toString() + "]");
                this.itsPool.returnObject((Object)connection);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to return Database connection to object pool: " + exception.getMessage(), exception);
            }
        }
    }

    private void logConnectionPoolState(int n2) {
        if (this.itsPool != null) {
            Util_Logger.info(logger, "Database Connection pool now has a total of " + (this.itsPool.getNumActive() + n2) + " active connections, " + this.itsPool.getNumIdle() + " idle connections");
        }
    }

    public void closePool() {
        this.itsPool.close();
    }

    public synchronized void clearCache() {
        try {
            Date date = Util.dateOffset(new Date(), -this.itsPoolTimeoutMins, 12);
            if (this.itsPoolLastCleared.before(date)) {
                this.createDatabaseConnectionPool();
                Util_Logger.warning(logger, "Flushed Database connection pool");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error clearing object pool cache for DatabaseConnectionPool:" + exception.getMessage(), exception);
        }
    }
}

