/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.DatabaseConfig;
import au.com.nemmco.Util.DbHandler;
import au.com.nemmco.Util.DbHandlerField;
import au.com.nemmco.Util.DbManager;
import au.com.nemmco.Util.DbPreparedStatementParam;
import au.com.nemmco.Util.DbSpaceStats;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerOracle
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerOracle.class);

    public DbHandlerOracle(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    @Override
    public void afterConnect(Connection connection) throws SQLException {
        block5: {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.execute("ALTER SESSION SET NLS_DATE_FORMAT='" + this.getDbDateFormat() + "'");
                if (!Util.isBlank(this.getDbTimestampFormat())) {
                    statement.execute("ALTER SESSION SET NLS_TIMESTAMP_FORMAT='" + this.getDbTimestampFormat() + "'");
                }
                statement.close();
            }
            catch (Exception exception) {
                if (statement == null) break block5;
                try {
                    statement.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean checkTableExists(Connection connection, String string, String string2) throws ApplicationException {
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            Object object = "select count(1) from ";
            object = Util.isBlank(string) ? (String)object + "user_tables" : (String)object + "all_tables";
            object = (String)object + " where table_name = '" + string2.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and owner = '" + string.toUpperCase() + "'";
            }
            resultSet = statement.executeQuery((String)object);
            while (resultSet.next()) {
                bl = resultSet.getInt(1) > 0;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in checkTableExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    @Override
    public boolean checkColumnExists(Connection connection, String string, String string2, String string3) throws ApplicationException {
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            Object object = "select count(1) from ";
            object = Util.isBlank(string) ? (String)object + "user_tab_columns" : (String)object + "all_tab_columns";
            object = (String)object + " where table_name = '" + string2.toUpperCase() + "'";
            object = (String)object + " and column_name = '" + string3.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and owner = '" + string.toUpperCase() + "'";
            }
            resultSet = statement.executeQuery((String)object);
            while (resultSet.next()) {
                bl = resultSet.getInt(1) > 0;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in checkColumnExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    @Override
    public boolean getPreferExistsStatement() {
        return true;
    }

    @Override
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        HashMap<String, DbHandlerField> hashMap = new HashMap<String, DbHandlerField>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            Object object = "select column_name,data_type,nvl(data_precision,data_length) as data_length,data_scale from ";
            object = Util.isBlank(string) ? (String)object + "user_tab_columns" : (String)object + "all_tab_columns";
            object = (String)object + " where table_name = '" + string2.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and owner = '" + string.toUpperCase() + "'";
            }
            object = (String)object + " order by column_id";
            resultSet = statement.executeQuery((String)object);
            while (resultSet.next()) {
                DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), hashMap.size());
                hashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getColumnList: " + sQLException.getMessage(), sQLException);
        }
        return hashMap;
    }

    @Override
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            Object object = "select cc.column_name from ";
            object = Util.isBlank(string) ? (String)object + "user_cons_columns cc, user_constraints c " : (String)object + "all_cons_columns cc, all_constraints c ";
            object = (String)object + " where c.table_name = '" + string2.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and c.owner = '" + string.toUpperCase() + "'";
            }
            object = (String)object + " and c.owner = cc.owner and c.constraint_name = cc.constraint_name  and c.constraint_type = 'P' order by cc.position";
            resultSet = statement.executeQuery((String)object);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    @Override
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l2 = -1L;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select " + this.getTableReference(string, string2) + ".nextval from dual");
            while (resultSet.next()) {
                l2 = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l2;
    }

    @Override
    public String getCurrentDateTime() {
        return "sysdate";
    }

    @Override
    public String getCurrentUser() {
        return "USER";
    }

    @Override
    public String getNoTable() {
        return "from dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "select\n     used.tablespace_name,\n     used.bytes as used_bytes,\n     reserv.maxbytes as max_bytes\nfrom\n    (select tablespace_name, count(1) datafiles, sum(greatest(maxbytes,bytes)) maxbytes, sum(bytes) bytes from dba_data_files group by tablespace_name) reserv,\n    (select tablespace_name, sum(bytes) bytes from dba_segments group by tablespace_name) used\n where used.tablespace_name = reserv.tablespace_name" + this.getTablespaceToReportSQL("and", "used.tablespace_name") + " order by 1";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("tablespace_name"));
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                dbSpaceStats.setTotalBytes(resultSet.getLong("max_bytes"));
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "to_date('" + string + "','" + this.getDbDateFormat() + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return this.getJavaDateFormat();
        }
        if (dbHandlerField.getFieldType().startsWith("TIMESTAMP")) {
            return this.getJavaTimestampFormat();
        }
        return null;
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField == null) {
            return new DbPreparedStatementParam("?", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("NUMBER")) {
            return new DbPreparedStatementParam("to_number(?)", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return new DbPreparedStatementParam("to_date(?,'" + this.getDbDateFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().startsWith("TIMESTAMP")) {
            return new DbPreparedStatementParam("to_timestamp(?,'" + this.getDbTimestampFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("CHAR")) {
            return new DbPreparedStatementParam(this.rightPad("?", dbHandlerField.getDataLength()), 12);
        }
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    public boolean isValid(Connection connection) {
        boolean bl;
        block5: {
            bl = false;
            if (connection != null) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.executeQuery("select 1 from dual");
                    statement.close();
                    bl = true;
                }
                catch (Exception exception) {
                    Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
                    if (statement == null) break block5;
                    try {
                        statement.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "NVL(" + string + "," + string2 + ")";
    }

    private String rightPad(String string, int n2) {
        return "RPAD(" + string + "," + n2 + ")";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n2) {
        return "SELECT * from (SELECT " + string + " ORDER BY " + string2 + " ) where rownum <= " + n2;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "bitand(" + string + "," + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n2) {
        int n3 = 1440 / n2;
        String string2 = "cast(" + string + " as DATE)";
        return "CEIL((" + string2 + " - trunc(" + string2 + ")) * " + n3 + " )/" + n3 + " + trunc(" + string2 + ")";
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) {
        return "((extract(day from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))*24*60*60+(extract(hour from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))*60*60+(extract(minute from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))*60+extract(second from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))";
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n2) throws Exception {
        switch (n2) {
            case 13: {
                return "(" + string + " + (" + string2 + "/86400))";
            }
            case 12: {
                return "(" + string + " + (" + string2 + "/1440))";
            }
            case 11: {
                return "(" + string + " + (" + string2 + "/24))";
            }
            case 5: {
                return "(" + string + " + (" + string2 + "))";
            }
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n2);
    }

    @Override
    public String getScriptDelimiter() {
        return "/";
    }
}

