/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.DatabaseConfig;
import au.com.nemmco.Util.DbHandler;
import au.com.nemmco.Util.DbHandler3PartTable;
import au.com.nemmco.Util.DbHandlerField;
import au.com.nemmco.Util.DbManager;
import au.com.nemmco.Util.DbPreparedStatementParam;
import au.com.nemmco.Util.DbSpaceStats;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerSqlServer
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerSqlServer.class);

    public DbHandlerSqlServer(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    @Override
    public void afterConnect(Connection connection) throws SQLException {
        block4: {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.execute("SET DATEFORMAT " + this.getDbDateFormat());
                statement.close();
            }
            catch (Exception exception) {
                if (statement == null) break block4;
                try {
                    statement.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        HashMap<String, DbHandlerField> hashMap = new HashMap<String, DbHandlerField>();
        Statement statement = null;
        ResultSet resultSet = null;
        DbHandler3PartTable dbHandler3PartTable = new DbHandler3PartTable(string, string2);
        try {
            statement = connection.createStatement();
            String string3 = "select col.name as columnname, typ.name ,col.prec as length, col.scale as precision from " + dbHandler3PartTable.getSysRef() + "sysobjects tbl," + dbHandler3PartTable.getSysRef() + "syscolumns col," + dbHandler3PartTable.getSysRef() + "systypes utyp," + dbHandler3PartTable.getSysRef() + "systypes typ  WHERE tbl.id = col.id and  tbl.xtype in ('U','V') and  tbl.id = OBJECT_ID('" + dbHandler3PartTable.getFullTable() + "') and col.number = 0 and utyp.xusertype = col.xusertype and typ.xusertype = utyp.xtype ORDER by tbl.xtype desc, col.colid";
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), hashMap.size());
                hashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getColumnList: " + sQLException.getMessage(), sQLException);
        }
        return hashMap;
    }

    private List<String> getPkListTable(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        DbHandler3PartTable dbHandler3PartTable = new DbHandler3PartTable(string, string2);
        try {
            statement = connection.createStatement();
            String string3 = "Select idx.name as index_name,idx.indid, idx.status FROM " + dbHandler3PartTable.getSysRef() + "sysindexes idx WHERE idx.ID = OBJECT_ID('" + dbHandler3PartTable.getFullTable() + "') and idx.STATUS & 2 = 2 and idx.indid < 255 order by idx.name";
            int n2 = -1;
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                n2 = resultSet.getInt("INDID");
            }
            resultSet.close();
            String string4 = "?";
            while (!Util.isBlank(string4) && n2 >= 0) {
                string3 = "select index_col ('" + dbHandler3PartTable.getFullTable() + "'," + n2 + "," + (arrayList.size() + 1) + ")";
                resultSet = statement.executeQuery(string3);
                string4 = null;
                while (resultSet.next()) {
                    string4 = resultSet.getString(1);
                }
                resultSet.close();
                if (string4 == null) continue;
                arrayList.add(string4.toUpperCase());
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    @Override
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        List<String> list = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        DbHandler3PartTable dbHandler3PartTable = new DbHandler3PartTable(string, string2);
        try {
            statement = connection.createStatement();
            String string3 = " select tbl2.name from " + dbHandler3PartTable.getSysRef() + "sysobjects tbl," + dbHandler3PartTable.getSysRef() + "sysdepends v," + dbHandler3PartTable.getSysRef() + "sysobjects tbl2 where tbl.id = OBJECT_ID('" + dbHandler3PartTable.getFullTable() + "') and tbl.xtype in ('U','V') and tbl.id = v.id and v.depid = tbl2.id and v.depnumber = 1 order by tbl.xtype desc, tbl2.name";
            String string4 = string2;
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                string4 = resultSet.getString("name");
            }
            resultSet.close();
            statement.close();
            if (logger.isDebugEnabled()) {
                Util_Logger.debug(logger, "Extracting PK columns for " + dbHandler3PartTable.getFullTable() + " from " + string4);
            }
            list = this.getPkListTable(connection, string, string4);
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return list;
    }

    @Override
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l2 = -1L;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT NEXT VALUE FOR " + this.getTableReference(string, string2));
            while (resultSet.next()) {
                l2 = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l2;
    }

    @Override
    public String getCurrentDateTime() {
        return "GETDATE()";
    }

    @Override
    public String getCurrentUser() {
        return "SUSER_SNAME()";
    }

    @Override
    public String getNoTable() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "Select b.groupname, SUM(cast(FILEPROPERTY(name, 'SpaceUsed') AS bigint) )*8*1024 as used_bytes, SUM(cast(max_size AS bigint))*8*1024 as max_bytes FROM sys.database_files a,sysfilegroups b where a.data_space_id=b.groupid" + this.getTablespaceToReportSQL("and", "b.groupname") + " group by b.groupname order by groupname";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("groupname").toUpperCase());
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                Long l2 = resultSet.getLong("max_bytes");
                if (l2 > 0L) {
                    dbSpaceStats.setTotalBytes(l2);
                }
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "convert(datetime,'" + string + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME")) {
            return this.getJavaTimestampFormat();
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME2")) {
            return this.getJavaTimestampFormat();
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return this.getJavaDateFormat();
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP")) {
            return this.getJavaTimestampFormat();
        }
        return null;
    }

    private boolean isDateField(DbHandlerField dbHandlerField) {
        return dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP") || dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME") || dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME2") || dbHandlerField.getFieldType().equalsIgnoreCase("DATE");
    }

    private String getSqlPreparedStatementDateFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME2")) {
            return "convert(datetime2(" + dbHandlerField.getDataScale() + "),?)";
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return "convert(date,?)";
        }
        return "convert(datetime,?)";
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField == null) {
            return new DbPreparedStatementParam("?", 12);
        }
        if (this.isDateField(dbHandlerField)) {
            return new DbPreparedStatementParam(this.getSqlPreparedStatementDateFormat(dbHandlerField), 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("CHAR")) {
            return new DbPreparedStatementParam(this.rightPad("?", dbHandlerField.getDataLength()), 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DECIMAL")) {
            return new DbPreparedStatementParam("CAST(CAST(? as FLOAT) AS DECIMAL(" + dbHandlerField.getDataLength() + "," + dbHandlerField.getDataScale() + "))", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("NUMERIC")) {
            return new DbPreparedStatementParam("CAST(CAST(? as FLOAT) AS NUMERIC(" + dbHandlerField.getDataLength() + "," + dbHandlerField.getDataScale() + "))", 12);
        }
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    public boolean isValid(Connection connection) {
        boolean bl;
        block5: {
            bl = false;
            if (connection != null) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.executeQuery("select getdate()");
                    statement.close();
                    bl = true;
                }
                catch (Exception exception) {
                    Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
                    if (statement == null) break block5;
                    try {
                        statement.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "ISNULL(" + string + "," + string2 + ")";
    }

    private String rightPad(String string, int n2) {
        return "cast(" + string + " as char(" + n2 + "))";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n2) {
        return "SELECT TOP " + n2 + string + " ORDER BY " + string2;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "(" + string + " & " + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n2) {
        return "DATEADD(MINUTE, " + n2 + " + FLOOR(DATEDIFF(MINUTE, 0, DATEADD(SECOND,-1," + string + ")) / " + n2 + ") * " + n2 + ", 0)";
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) throws Exception {
        return "DATEDIFF(millisecond," + string + "," + string2 + ")/1000";
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n2) throws Exception {
        switch (n2) {
            case 13: {
                return "DATEADD(second," + string2 + "," + string + ")";
            }
            case 12: {
                return "DATEADD(minute," + string2 + "," + string + ")";
            }
            case 11: {
                return "DATEADD(hour," + string2 + "," + string + ")";
            }
            case 5: {
                return "DATEADD(day," + string2 + "," + string + ")";
            }
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n2);
    }

    @Override
    public String getScriptDelimiter() {
        return "go";
    }
}

