/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.DatabaseConfig;
import au.com.nemmco.Util.DbHandler;
import au.com.nemmco.Util.DbHandler3PartTable;
import au.com.nemmco.Util.DbHandlerField;
import au.com.nemmco.Util.DbPreparedStatementParam;
import au.com.nemmco.Util.DbSpaceStats;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerSybase
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerSybase.class);

    public DbHandlerSybase(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    @Override
    public void afterConnect(Connection connection) throws SQLException {
        block4: {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.execute("SET DATEFORMAT " + this.getDbDateFormat());
                statement.close();
            }
            catch (Exception exception) {
                if (statement == null) break block4;
                try {
                    statement.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean getPreferExistsStatement() {
        return false;
    }

    @Override
    public int maptoFieldTypeId(String string) {
        if (string.equalsIgnoreCase("decimal")) {
            return 3;
        }
        if (string.equalsIgnoreCase("datetime")) {
            return 93;
        }
        if (string.equalsIgnoreCase("float")) {
            return 6;
        }
        if (string.equalsIgnoreCase("int")) {
            return 4;
        }
        if (string.equalsIgnoreCase("numeric")) {
            return 2;
        }
        if (string.equalsIgnoreCase("real")) {
            return 7;
        }
        if (string.equalsIgnoreCase("smallint")) {
            return 5;
        }
        if (string.equalsIgnoreCase("tinyint")) {
            return -6;
        }
        if (string.equalsIgnoreCase("char")) {
            return 1;
        }
        return 12;
    }

    @Override
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        HashMap<String, DbHandlerField> hashMap = new HashMap<String, DbHandlerField>();
        Statement statement = null;
        ResultSet resultSet = null;
        DbHandler3PartTable dbHandler3PartTable = new DbHandler3PartTable(string, string2);
        try {
            statement = connection.createStatement();
            String string3 = "select col.name as columnname, d.type_name, col.length, col.scale as precision from " + dbHandler3PartTable.getSysRef() + "sysobjects tbl," + dbHandler3PartTable.getSysRef() + "syscolumns col," + dbHandler3PartTable.getSysRef() + "systypes typ, sybsystemprocs.dbo.spt_datatype_info d  WHERE tbl.id = col.id and  tbl.type  = 'U' and typ.type = d.ss_dtype and tbl.id = OBJECT_ID('" + dbHandler3PartTable.getFullTable() + "') and col.usertype = typ.usertype and col.number = 0 ORDER by col.colid";
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), hashMap.size());
                hashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getColumnList: " + sQLException.getMessage(), sQLException);
        }
        return hashMap;
    }

    @Override
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        DbHandler3PartTable dbHandler3PartTable = new DbHandler3PartTable(string, string2);
        try {
            statement = connection.createStatement();
            String string3 = "Select idx.name as index_name,idx.indid, idx.status FROM " + dbHandler3PartTable.getSysRef() + "sysindexes idx WHERE idx.id = OBJECT_ID('" + dbHandler3PartTable.getFullTable() + "') and idx.status & 2 = 2 and idx.indid < 255 order by idx.name";
            int n2 = -1;
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                n2 = resultSet.getInt("INDID");
            }
            resultSet.close();
            String string4 = "?";
            while (!Util.isBlank(string4) && n2 >= 0) {
                string3 = "select index_col ('" + dbHandler3PartTable.getFullTable() + "'," + n2 + "," + (arrayList.size() + 1) + ")";
                resultSet = statement.executeQuery(string3);
                string4 = null;
                while (resultSet.next()) {
                    string4 = resultSet.getString(1);
                }
                resultSet.close();
                if (string4 == null) continue;
                arrayList.add(string4.toUpperCase());
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    @Override
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l2 = -1L;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("exec " + this.getTableReference(string, string2));
            while (resultSet.next()) {
                l2 = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l2;
    }

    @Override
    public String getCurrentDateTime() {
        return "GETDATE()";
    }

    @Override
    public String getCurrentUser() {
        return "SUSER_NAME()";
    }

    @Override
    public String getNoTable() {
        return "";
    }

    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        Util_Logger.error(logger, "Database space usage not supported");
        return null;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "convert(datetime,'" + string + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return string + " + " + string2;
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        return null;
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    public boolean isValid(Connection connection) {
        boolean bl;
        block5: {
            bl = false;
            if (connection != null) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.executeQuery("select getdate()");
                    statement.close();
                    bl = true;
                }
                catch (Exception exception) {
                    Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
                    if (statement == null) break block5;
                    try {
                        statement.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "ISNULL(" + string + "," + string2 + ")";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n2) {
        return "SELECT TOP " + n2 + string + " ORDER BY " + string2;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "(" + string + " & " + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n2) throws Exception {
        throw new Exception("Unsupported function round date to " + n2 + " minutes");
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) throws Exception {
        throw new Exception("Unsupported function date difference in seconds");
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n2) throws Exception {
        switch (n2) {
            default: 
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n2);
    }
}

