/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.Util_Logger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockWrapper {
    private static Logger logger = LoggerFactory.getLogger(FileLockWrapper.class);
    private String itsLockFile;
    private RandomAccessFile raf;
    private FileChannel channel;
    private FileLock lock;
    private boolean persistentFile;

    public boolean setFileLock(String string, boolean bl) {
        this.itsLockFile = string;
        boolean bl2 = false;
        try {
            File file = new File(string);
            if (!bl) {
                FileUtilities.touch(file);
            }
            this.raf = new RandomAccessFile(file, "rwd");
            this.channel = this.raf.getChannel();
            this.lock = this.channel.tryLock();
            if (this.lock != null) {
                bl2 = true;
            } else {
                this.channel.close();
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error setting lock file: " + exception.getMessage(), exception);
        }
        return bl2;
    }

    public String readFile() throws IOException {
        String string = null;
        if (this.channel != null) {
            this.channel.position(0L);
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.channel.size());
            long l2 = this.channel.read(byteBuffer);
            string = new String(byteBuffer.array());
        }
        return string;
    }

    public void updateLockFile(String string) {
        if (this.lock != null) {
            try {
                this.raf.setLength(0L);
                this.channel.position(0L);
                this.channel.write(ByteBuffer.wrap(string.getBytes()));
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error updating lock file: " + exception.getMessage(), exception);
            }
        }
    }

    public void releaseFileLock() {
        try {
            if (this.lock != null) {
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.lock.isValid()) {
                    this.lock.release();
                }
                if (!this.persistentFile) {
                    FileUtilities.deleteFile(this.itsLockFile);
                }
            }
        }
        catch (IOException iOException) {
            Util_Logger.errorNoRaise(logger, "Error releasing lock file: " + iOException.getMessage(), iOException);
        }
    }
}

