/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FilePurgeThreadRec;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePurgeThread
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(FilePurgeThread.class);
    private boolean itsIsRunning;
    private int itsDelayMins;
    private FilePurgeThreadRec[] itsPurgeRecs;

    public FilePurgeThread(Properties properties) throws ApplicationException {
        String string = Util.getProperty(properties, "file_purge_configurations", "");
        if (!Util.isBlank(string)) {
            String[] stringArray = Util.getColumns(string, ',');
            this.itsPurgeRecs = new FilePurgeThreadRec[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                FilePurgeThreadRec filePurgeThreadRec;
                String string2 = stringArray[i2];
                Util_Logger.info(logger, "Adding automated filesystem purging configuration " + string2);
                String string3 = Util.getProperty(properties, "file_purge_" + string2 + "_directory");
                int n2 = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_retention_time_mins", "-1"));
                int n3 = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_max_no_files", "-1"));
                int n4 = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_max_size_MB", "-1"));
                int n5 = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_purge_frequency_mins", "1440"));
                String string4 = Util.getProperty(properties, "file_purge_" + string2 + "_inc", null);
                String string5 = Util.getProperty(properties, "file_purge_" + string2 + "_exc", null);
                this.itsPurgeRecs[i2] = filePurgeThreadRec = new FilePurgeThreadRec(string3, n2, n3, n4, n5, string4, string5);
            }
        }
        this.itsIsRunning = true;
    }

    public boolean getHasConfiguration() {
        return this.itsPurgeRecs != null;
    }

    public void stop() {
        this.itsIsRunning = false;
    }

    @Override
    public void run() {
        while (this.itsIsRunning) {
            try {
                if (this.itsPurgeRecs != null) {
                    for (int i2 = 0; i2 < this.itsPurgeRecs.length; ++i2) {
                        this.itsPurgeRecs[i2].runCheck();
                    }
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Detected exception in filesystem purge thread: " + exception.getMessage(), exception);
            }
            try {
                Util_Logger.debug(logger, "Sleeping for 2 mins in filesystem purge thread");
                Thread.sleep(120000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

