/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FilesystemMonitor;
import au.com.nemmco.Util.FilesystemMonitorConfig;
import au.com.nemmco.Util.FilesystemStatus;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.io.File;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemManager {
    private static Logger logger = LoggerFactory.getLogger(FilesystemManager.class);
    private FilesystemMonitorConfig Config;

    private FilesystemManager() {
    }

    public static FilesystemManager getInstance() {
        return SingletonHolder.instance;
    }

    public void configure(FilesystemMonitorConfig filesystemMonitorConfig) {
        if (filesystemMonitorConfig != null && filesystemMonitorConfig.Filesystem != null) {
            ArrayList<FilesystemMonitor> arrayList = new ArrayList<FilesystemMonitor>();
            for (FilesystemMonitor filesystemMonitor : filesystemMonitorConfig.Filesystem) {
                if (new File(filesystemMonitor.Path).exists()) {
                    arrayList.add(filesystemMonitor);
                    continue;
                }
                Util_Logger.warning(logger, "Ignoring file system monitoring for invalid path " + filesystemMonitor.Path);
            }
            filesystemMonitorConfig.Filesystem = arrayList;
            if (filesystemMonitorConfig.Filesystem.size() > 0) {
                this.Config = filesystemMonitorConfig;
                Util_Logger.info(logger, "Loaded " + this.Config.Filesystem.size() + " filesystem monitoring configurations");
            }
        }
    }

    public static FilesystemMonitorConfig loadConfigFromProperties(Properties properties) throws ApplicationException {
        String[] stringArray;
        FilesystemMonitorConfig filesystemMonitorConfig = new FilesystemMonitorConfig();
        String string = Util.getProperty(properties, "filesystem_monitor_configurations", null);
        if (!Util.isBlank(string) && (stringArray = Util.getColumns(string, ',')) != null) {
            for (String string2 : stringArray) {
                String string3;
                String string4;
                if (Util.isBlank(string2)) continue;
                FilesystemMonitor filesystemMonitor = new FilesystemMonitor();
                filesystemMonitor.Path = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_path", null);
                String string5 = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_warning_pct", null);
                if (Util.isInteger(string5)) {
                    filesystemMonitor.WarningPct = Integer.valueOf(string5);
                }
                if (Util.isInteger(string4 = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_alert_pct", null))) {
                    filesystemMonitor.AlertPct = Integer.valueOf(string4);
                }
                if (Util.isInteger(string3 = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_check_interval_minutes", null))) {
                    filesystemMonitor.CheckIntervalMinutes = Integer.valueOf(string3);
                }
                filesystemMonitorConfig.Filesystem.add(filesystemMonitor);
            }
        }
        return filesystemMonitorConfig;
    }

    private FilesystemStatus getStatus(FilesystemMonitor filesystemMonitor) {
        FilesystemStatus filesystemStatus = null;
        try {
            URI uRI = new URI("file:///");
            Path path = Paths.get(uRI);
            Path path2 = path.resolve(filesystemMonitor.Path);
            FileStore fileStore = Files.getFileStore(path2);
            long l2 = fileStore.getTotalSpace();
            long l3 = fileStore.getTotalSpace() - fileStore.getUnallocatedSpace();
            long l4 = fileStore.getUsableSpace();
            filesystemStatus = new FilesystemStatus(filesystemMonitor.Path, fileStore.name());
            filesystemStatus.setTotalBytes(l2);
            filesystemStatus.setUsedBytes(l3);
            filesystemStatus.setAvailBytes(l4);
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Unable to check filesystem at " + filesystemMonitor.Path + ": " + exception.getMessage(), exception);
            filesystemStatus = null;
        }
        return filesystemStatus;
    }

    public List<FilesystemStatus> getStatus() {
        ArrayList<FilesystemStatus> arrayList = new ArrayList<FilesystemStatus>();
        if (this.Config != null) {
            for (FilesystemMonitor filesystemMonitor : this.Config.Filesystem) {
                FilesystemStatus filesystemStatus = this.getStatus(filesystemMonitor);
                if (filesystemStatus == null) continue;
                arrayList.add(filesystemStatus);
            }
        }
        return arrayList;
    }

    public void doCheck() {
        if (this.Config != null) {
            ArrayList arrayList = new ArrayList();
            for (FilesystemMonitor filesystemMonitor : this.Config.Filesystem) {
                Object object;
                boolean bl = false;
                if (filesystemMonitor.LastChecked == null) {
                    bl = true;
                } else {
                    object = Util.dateOffset(new Date(), -filesystemMonitor.CheckIntervalMinutes.intValue(), 12);
                    if (filesystemMonitor.LastChecked.before((Date)object)) {
                        bl = true;
                    }
                }
                if (!bl || (object = this.getStatus(filesystemMonitor)) == null) continue;
                boolean bl2 = false;
                if (filesystemMonitor.AlertPct != null && ((FilesystemStatus)object).getPercentFull() * 100.0 > (double)filesystemMonitor.AlertPct.intValue()) {
                    bl2 = true;
                }
                boolean bl3 = false;
                if (filesystemMonitor.WarningPct != null && ((FilesystemStatus)object).getPercentFull() * 100.0 > (double)filesystemMonitor.WarningPct.intValue()) {
                    bl3 = true;
                }
                String string = ((FilesystemStatus)object).getDisplayName();
                String string2 = Util.formatBytes(((FilesystemStatus)object).getUsedBytes());
                String string3 = Util.formatBytes(((FilesystemStatus)object).getTotalBytes());
                String string4 = String.format("%.1f%s", ((FilesystemStatus)object).getPercentFull() * 100.0, "%");
                String string5 = String.format("%d%s", filesystemMonitor.WarningPct, "%");
                String string6 = String.format("%d%s", filesystemMonitor.AlertPct, "%");
                if (bl2) {
                    Util_Logger.errorNoRaise(logger, "Filesystem [" + string + "] Used space above " + string6 + " threshold: Used=" + string2 + ", Total=" + string3 + ", UsedPct=" + string4);
                } else if (bl3) {
                    Util_Logger.warning(logger, "Filesystem [" + string + "] Used space above " + string5 + " threshold: Used=" + string2 + ", Total=" + string3 + ", UsedPct=" + string4);
                } else {
                    Util_Logger.info(logger, "Filesystem [" + string + "] Used=" + string2 + ", Total=" + string3 + ", FreePct=" + string4);
                }
                filesystemMonitor.LastChecked = new Date();
            }
        }
    }

    private static class SingletonHolder {
        private static FilesystemManager instance = new FilesystemManager();

        private SingletonHolder() {
        }
    }
}

