/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.FtpConnectionIntBase;
import au.com.nemmco.Util.FtpException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.PrintCommandListener;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnectionIntApache
extends FtpConnectionIntBase {
    private static Logger logger = LoggerFactory.getLogger(FtpConnectionIntApache.class);
    private FTPClient itsFtp;
    private boolean itsLoggedBandwidthWarning = false;
    private SimpleDateFormat modTimeDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public void connect(String string, Integer n2, String string2, String string3, String string4, String string5, String string6, int n3, String string7, String string8, String string9, boolean bl, boolean bl2, String string10, String string11, String string12, boolean bl3) throws Exception {
        this.setId(string8);
        this.setExtractLastModifiedDate(bl);
        this.itsFtp = Util.isBlank(string5) ? new FTPClient() : new FTPHTTPClient(string5, Integer.parseInt(string6), string2, string3);
        if (logger.isDebugEnabled()) {
            this.itsFtp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(logger, this.getId()));
        }
        if (n2 == null) {
            this.itsFtp.connect(string);
        } else {
            this.itsFtp.connect(string, n2.intValue());
        }
        if (string7.equalsIgnoreCase("active")) {
            this.itsFtp.enterLocalActiveMode();
        } else if (string7.equalsIgnoreCase("passive")) {
            this.itsFtp.enterLocalPassiveMode();
        } else {
            throw new Exception("Unknown FTP connect mode " + string7);
        }
        this.itsFtp.setDataTimeout(n3 * 1000);
        this.itsFtp.login(string2, string3);
        try {
            String string13 = "App: " + string9;
            try {
                String string14 = InetAddress.getLocalHost().getHostName();
                string13 = string13 + "; Host:" + string14;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.itsFtp.sendCommand(string13);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void disconnect() throws FtpException, IOException {
        try {
            this.itsFtp.disconnect();
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
    }

    @Override
    public boolean isConnected() {
        boolean bl = false;
        try {
            bl = this.itsFtp.isConnected();
            if (bl) {
                bl = this.itsFtp.sendNoOp();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void logBandwidthWarning() {
        if (!this.itsLoggedBandwidthWarning) {
            Util_Logger.warning(logger, "Bandwidth throttling not supported in Apache FTP provider");
            this.itsLoggedBandwidthWarning = true;
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
        this.logBandwidthWarning();
    }

    @Override
    public void resetBandwidthThrottle() {
    }

    @Override
    public void setTransferBufferSize(int n2) {
        Util_Logger.warning(logger, "Transfer buffer size not supported in Apache FTP provider");
    }

    @Override
    public void chdirImp(String string) throws FtpException, IOException {
        boolean bl = false;
        try {
            bl = this.itsFtp.changeWorkingDirectory(string);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to change directory to " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void mkdir(String string) throws FtpException, IOException {
        boolean bl = false;
        try {
            bl = this.itsFtp.makeDirectory(string);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to make directory to " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void setType(String string) throws FtpException, IOException {
        boolean bl = false;
        int n2 = 0;
        if (!string.equalsIgnoreCase("binary")) {
            throw new FtpException("Unknown FTP transfer mode " + string);
        }
        n2 = 2;
        try {
            bl = this.itsFtp.setFileType(n2);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to set transfer type to " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void put(String string, String string2) throws FtpException, IOException {
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(string);
            bl = this.itsFtp.storeFile(string2, (InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to put file " + string2 + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public FtpFileInfo[] dir(String string, String string2) throws FtpException, IOException {
        FtpFileInfo[] ftpFileInfoArray = null;
        try {
            FTPFile[] fTPFileArray;
            Object object = string;
            if (!Util.isBlank(string2)) {
                object = (String)object + "/" + string2;
            }
            if ((fTPFileArray = this.itsFtp.listFiles((String)object)) != null) {
                ftpFileInfoArray = new FtpFileInfo[fTPFileArray.length];
                for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
                    FtpFileInfo ftpFileInfo = new FtpFileInfo();
                    ftpFileInfo.setDirectory(string);
                    ftpFileInfo.setFilename(fTPFileArray[i2].getName());
                    ftpFileInfo.setSize(fTPFileArray[i2].getSize());
                    ftpFileInfo.setModifiedDate(fTPFileArray[i2].getTimestamp().getTime(), false);
                    if (fTPFileArray[i2].isDirectory()) {
                        ftpFileInfo.setFileType(FtpFileTypeEnum.DIRECTORY);
                    } else {
                        String string3;
                        ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
                        if (this.getExtractLastModifiedDate() && !Util.isBlank(string3 = this.itsFtp.getModificationTime(string + "/" + fTPFileArray[i2].getName()))) {
                            Date date = this.modTimeDateFormat.parse(string3.substring(string3.indexOf(" ") + 1));
                            ftpFileInfo.setModifiedDate(date, true);
                        }
                    }
                    ftpFileInfoArray[i2] = ftpFileInfo;
                }
            }
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        return ftpFileInfoArray;
    }

    @Override
    public void delete(String string) throws FtpException, IOException {
        boolean bl = false;
        try {
            bl = this.itsFtp.deleteFile(string);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to delete file " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void get(String string, String string2) throws FtpException, IOException {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(string + "/" + string2);
            bl = this.itsFtp.retrieveFile(string2, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to get file " + string2 + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public boolean exists(String string, String string2) throws FtpException {
        try {
            FtpFileInfo[] ftpFileInfoArray = this.dir(string + "/" + string2, null);
            return ftpFileInfoArray != null;
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws FtpException, IOException {
        boolean bl = false;
        try {
            String string = this.itsFtp.getModificationTime(ftpFileInfo.getDirectory() + "/" + ftpFileInfo.getFilename());
            if (!Util.isBlank(string)) {
                Date date = this.modTimeDateFormat.parse(string.substring(string.indexOf(" ") + 1));
                ftpFileInfo.setModifiedDate(date, true);
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        return bl;
    }

    @Override
    public void rename(String string, String string2) throws FtpException {
        try {
            this.itsFtp.rename(string, string2);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
    }
}

