/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.FTPClientExtension;
import au.com.nemmco.Util.FtpConnectionIntBase;
import au.com.nemmco.Util.FtpException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.util.license.License;
import com.enterprisedt.util.proxy.ProxyType;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnectionIntEDT
extends FtpConnectionIntBase
implements FTPMessageListener {
    private static Logger logger = LoggerFactory.getLogger(FtpConnectionIntEDT.class);
    private FTPClientExtension itsFtp;
    private static boolean licenceDetailsAdded = false;

    @Override
    public void logCommand(String string) {
        Util_Logger.debug(logger, "FTP COMMAND [" + this.getId() + "] - " + string);
    }

    @Override
    public void logReply(String string) {
        Util_Logger.debug(logger, "FTP REPLY [" + this.getId() + "] - " + string);
    }

    private synchronized void setLicenceDetails() {
        if (!licenceDetailsAdded) {
            License.setLicenseDetails("AEMO.com.au", "382-2681-9839-9862");
            licenceDetailsAdded = true;
            Util_Logger.debug(logger, "Registered licence details for EnterpriseDT FTP component");
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public void connect(String string, Integer n2, String string2, String string3, String string4, String string5, String string6, int n3, String string7, String string8, String string9, boolean bl, boolean bl2, String string10, String string11, String string12, boolean bl3) throws Exception {
        this.setLicenceDetails();
        this.setId(string8);
        this.setExtractLastModifiedDate(bl);
        this.itsFtp = new FTPClientExtension();
        this.itsFtp.setRemoteHost(string);
        if (n2 != null) {
            this.itsFtp.setRemotePort(n2);
        }
        if (string7.equalsIgnoreCase("active")) {
            this.itsFtp.setConnectMode(FTPConnectMode.ACTIVE);
        } else if (string7.equalsIgnoreCase("passive")) {
            this.itsFtp.setConnectMode(FTPConnectMode.PASV);
        } else {
            throw new Exception("Unknown FTP connect mode " + string7);
        }
        if (logger.isDebugEnabled()) {
            this.itsFtp.setMessageListener(this);
        }
        this.itsFtp.setTimeout(n3 * 1000);
        if (!Util.isBlank(string5)) {
            this.itsFtp.getProxySettings().setProxyAddress(string5);
            this.itsFtp.getProxySettings().setProxyPort(Integer.parseInt(string6));
            this.itsFtp.getProxySettings().setProxyType(ProxyType.HTTP);
        }
        this.itsFtp.connect();
        if (Util.isBlank(string4)) {
            this.itsFtp.login(string2, string3);
        } else {
            this.itsFtp.login(string2, string3, string4);
        }
        try {
            String string13 = "App: " + string9;
            try {
                String string14 = InetAddress.getLocalHost().getHostName();
                string13 = string13 + "; Host:" + string14;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.itsFtp.quote(string13);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void disconnect() throws FtpException, IOException {
        try {
            this.itsFtp.quit();
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public boolean isConnected() {
        boolean bl = false;
        try {
            Util_Logger.debug(logger, "Testing FTP connection [" + this.getId() + "]: " + this.itsFtp.toString());
            this.itsFtp.keepAlive();
            bl = this.itsFtp.connected();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void setBandwidthThrottle(int n2) {
        this.itsFtp.setBandwidthThrottle(n2);
    }

    @Override
    public void resetBandwidthThrottle() {
        this.itsFtp.resetBandwidthThrottle();
    }

    @Override
    public void setTransferBufferSize(int n2) {
        this.itsFtp.setTransferBufferSize(n2);
    }

    @Override
    public void chdirImp(String string) throws FtpException, IOException {
        try {
            this.itsFtp.chdir(string);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public void mkdir(String string) throws FtpException, IOException {
        try {
            this.itsFtp.mkdir(string);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public void setType(String string) throws FtpException, IOException {
        try {
            if (!string.equalsIgnoreCase("binary")) {
                throw new FtpException("Unknown FTP transfer mode " + string);
            }
            this.itsFtp.setType(FTPTransferType.BINARY);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public void put(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.put(string, string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public FtpFileInfo[] dir(String string, String string2) throws FtpException, IOException, ParseException {
        FtpFileInfo[] ftpFileInfoArray = null;
        try {
            FTPFile[] fTPFileArray;
            Object object = string;
            if (!Util.isBlank(string2)) {
                object = (String)object + "/" + string2;
            }
            if ((fTPFileArray = this.itsFtp.dirDetails((String)object)) != null) {
                ftpFileInfoArray = new FtpFileInfo[fTPFileArray.length];
                for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
                    FtpFileInfo ftpFileInfo = new FtpFileInfo();
                    ftpFileInfo.setDirectory(string);
                    ftpFileInfo.setFilename(fTPFileArray[i2].getName());
                    ftpFileInfo.setSize(fTPFileArray[i2].size());
                    ftpFileInfo.setModifiedDate(fTPFileArray[i2].lastModified(), false);
                    if (fTPFileArray[i2].isDir()) {
                        ftpFileInfo.setFileType(FtpFileTypeEnum.DIRECTORY);
                    } else {
                        ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
                        if (this.getExtractLastModifiedDate()) {
                            Date date = this.itsFtp.modtime(string + "/" + fTPFileArray[i2].getName());
                            ftpFileInfo.setModifiedDate(date, true);
                        }
                    }
                    ftpFileInfoArray[i2] = ftpFileInfo;
                }
            }
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
        return ftpFileInfoArray;
    }

    @Override
    public void delete(String string) throws FtpException, IOException {
        try {
            this.itsFtp.delete(string);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public void get(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.get(string, string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public boolean exists(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.chdir(string);
            return this.itsFtp.existsFile(string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws FtpException, IOException {
        boolean bl;
        block3: {
            bl = false;
            try {
                this.itsFtp.chdir(ftpFileInfo.getDirectory());
                Date date = this.itsFtp.modtime(ftpFileInfo.getFilename());
                if (date != null) {
                    ftpFileInfo.setModifiedDate(date, true);
                    bl = true;
                }
            }
            catch (FTPException fTPException) {
                if (fTPException.getReplyCode() == 550) break block3;
                throw new FtpException(fTPException, fTPException.getReplyCode());
            }
        }
        return bl;
    }

    @Override
    public void rename(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.rename(string, string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException(fTPException, fTPException.getReplyCode());
        }
    }
}

