/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.AuthIdentityConfig;
import au.com.nemmco.Util.AuthenticationConfig;
import au.com.nemmco.Util.DbManager;
import au.com.nemmco.Util.IdentityGrants;
import au.com.nemmco.Util.IdentityPrincipal;
import au.com.nemmco.Util.IdentityProviderInt;
import au.com.nemmco.Util.IdentityRole;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityProviderDB
implements IdentityProviderInt {
    private static Logger logger = LoggerFactory.getLogger(IdentityProviderDB.class);
    private AuthenticationConfig authConfig;
    private AuthIdentityConfig i;

    @Override
    public String getId() {
        return "LOCAL_IDENTITY_STORE";
    }

    @Override
    public void configure(AuthenticationConfig authenticationConfig) throws Exception {
        this.authConfig = authenticationConfig;
        if (!Util.isBlank(this.authConfig.PasswordEncryptionKey)) {
            if (this.authConfig.PasswordEncryptionKey.length() != 32) {
                throw new Exception("Invalid parameter PasswordEncryptionKey, needs to be 32 digit hexadecimal key");
            }
            if (!Util.isHex(this.authConfig.PasswordEncryptionKey)) {
                throw new Exception("Invalid parameter PasswordEncryptionKey, needs to be 32 digit hexadecimal key");
            }
        }
        this.loadData();
        if (this.authConfig.CacheExpiryTimeMins > 0) {
            this.scheduleCacheRefresh(this);
        } else {
            Util_Logger.warning(logger, "Missing Authenticaton configuration parameter CacheExpiryTimeMins, user cache will never expire");
        }
    }

    public void scheduleCacheRefresh(final IdentityProviderDB identityProviderDB) {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("IDENTITY_CACHE_MANAGER");
                thread.setDaemon(true);
                return thread;
            }
        });
        scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                identityProviderDB.loadData();
            }
        }, 1L, identityProviderDB.authConfig.CacheExpiryTimeMins, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            String string = "select * from " + DbManager.getDbHandler().getTableReference(this.authConfig.DbSchema, this.authConfig.DbTableUsers);
            List<IdentityPrincipal> list = DbManager.selectObjects(connection, IdentityPrincipal.class, this.authConfig.DbSchema, this.authConfig.DbTableUsers, string);
            string = "select * from " + DbManager.getDbHandler().getTableReference(this.authConfig.DbSchema, this.authConfig.DbTableRoles);
            List<IdentityRole> list2 = DbManager.selectObjects(connection, IdentityRole.class, this.authConfig.DbSchema, this.authConfig.DbTableRoles, string);
            string = "select * from " + DbManager.getDbHandler().getTableReference(this.authConfig.DbSchema, this.authConfig.DbTableUserGrants);
            List<IdentityGrants> list3 = DbManager.selectObjects(connection, IdentityGrants.class, this.authConfig.DbSchema, this.authConfig.DbTableUserGrants, string);
            AuthIdentityConfig authIdentityConfig = new AuthIdentityConfig();
            for (IdentityPrincipal object : list) {
                authIdentityConfig.Users.put(object.User_Id.toUpperCase().trim(), object);
            }
            for (IdentityGrants identityGrants : list3) {
                IdentityPrincipal identityPrincipal = authIdentityConfig.Users.get(identityGrants.User_Id.toUpperCase().trim());
                if (identityPrincipal == null) continue;
                identityPrincipal.Roles.add(identityGrants);
            }
            for (IdentityRole identityRole : list2) {
                authIdentityConfig.Roles.add(identityRole);
            }
            if (this.i == null) {
                this.i = authIdentityConfig;
            } else {
                AuthIdentityConfig authIdentityConfig2 = this.i;
                synchronized (authIdentityConfig2) {
                    this.i = authIdentityConfig;
                }
            }
            Util_Logger.info(logger, "Loaded " + this.i.Users.size() + " users from database");
            Util_Logger.info(logger, "Loaded " + this.i.Roles.size() + " roles from database");
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error loading user data from database: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePassword(String string, String string2) throws Exception {
        String string3;
        if (Util.isBlank(string)) {
            throw new Exception("Missing Username");
        }
        if (Util.isBlank(string2)) {
            throw new Exception("Missing Password");
        }
        IdentityPrincipal identityPrincipal = this.i.Users.get(string.toUpperCase().trim());
        if (identityPrincipal == null) {
            throw new Exception("Unknown user " + string);
        }
        identityPrincipal.Password = string3 = this.encyptPassword(string2);
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            DbManager.updateObject(connection, IdentityPrincipal.class, this.authConfig.DbSchema, this.authConfig.DbTableUsers, identityPrincipal);
            connection.commit();
            Util_Logger.info(logger, "Successfully updated password for user " + string);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
    }

    private String encyptPassword(String string) throws Exception {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            if (!Util.isBlank(this.authConfig.PasswordEncryptionKey)) {
                messageDigest.update(Hex.decodeHex(this.authConfig.PasswordEncryptionKey.toCharArray()));
            }
            byte[] byArray = messageDigest.digest(string.getBytes());
            string2 = Hex.encodeHexString(byArray);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error encrypting password: " + exception.getMessage(), exception);
        }
        return string2;
    }

    @Override
    public IdentityPrincipal authenticateUser(String string, String string2) {
        IdentityPrincipal identityPrincipal = null;
        try {
            String string3;
            IdentityPrincipal identityPrincipal2 = this.i.Users.get(string.toUpperCase().trim());
            if (identityPrincipal2 != null && Util.intToBoolean(identityPrincipal2.Is_Active) && (string3 = this.encyptPassword(string2)).equals(identityPrincipal2.Password)) {
                identityPrincipal = identityPrincipal2;
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error processing user login: " + exception.getMessage(), exception);
        }
        return identityPrincipal;
    }

    @Override
    public List<IdentityRole> getRoles() {
        if (this.i != null) {
            return this.i.Roles;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] updateRoles(List<IdentityRole> list) throws Exception {
        Connection connection = null;
        int[] nArray = null;
        try {
            connection = DbManager.getDbConnection();
            nArray = DbManager.upsertObjects(connection, IdentityRole.class, this.authConfig.DbSchema, this.authConfig.DbTableRoles, list);
            connection.commit();
            this.loadData();
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error creating new role: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return nArray;
    }

    @Override
    public List<IdentityPrincipal> getUsers() {
        if (this.i != null) {
            return new ArrayList<IdentityPrincipal>(this.i.Users.values());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createUser(IdentityPrincipal identityPrincipal) throws Exception {
        if (identityPrincipal != null) {
            IdentityGrants identityGrants;
            Object object;
            identityPrincipal.User_Id = identityPrincipal.User_Id.toUpperCase().trim();
            if (Util.isBlank(identityPrincipal.Password)) {
                object = this.i.Users.get(identityPrincipal.User_Id.toUpperCase());
                identityPrincipal.Password = ((IdentityPrincipal)object).Password;
            } else {
                identityPrincipal.Password = this.encyptPassword(identityPrincipal.Password);
            }
            object = new ArrayList();
            for (IdentityRole object2 : identityPrincipal.Roles) {
                identityGrants = new IdentityGrants();
                identityGrants.Role_Id = object2.Role_Id;
                identityGrants.Is_Active = object2.Is_Active;
                identityGrants.User_Id = identityPrincipal.User_Id;
                object.add(identityGrants);
            }
            if (identityPrincipal.User_Id.equalsIgnoreCase("ADMIN")) {
                if (!Util.intToBoolean(identityPrincipal.Is_Active)) {
                    identityPrincipal.Is_Active = 1;
                    Util_Logger.warning(logger, "ADMIN user can not be set inactive, re-enabling ADMIN user before saving user record");
                }
                boolean bl = false;
                Iterator exception = object.iterator();
                while (exception.hasNext()) {
                    identityGrants = (IdentityGrants)exception.next();
                    if (!identityGrants.Role_Id.equalsIgnoreCase(this.authConfig.AdminRole)) continue;
                    if (!Util.intToBoolean(identityGrants.Is_Active)) {
                        identityGrants.Is_Active = 1;
                        Util_Logger.warning(logger, "Role [" + this.authConfig.AdminRole + "] can not be disabled for ADMIN user, re-enabling before saving user record");
                    }
                    bl = true;
                }
                if (!bl) {
                    IdentityGrants identityGrants2 = new IdentityGrants();
                    identityGrants2.Role_Id = this.authConfig.AdminRole;
                    identityGrants2.Is_Active = 1;
                    identityGrants2.User_Id = identityPrincipal.User_Id;
                    object.add(identityGrants2);
                    Util_Logger.warning(logger, "Role [" + this.authConfig.AdminRole + "] can not be removed from ADMIN user, adding before saving user record");
                }
            }
            Object object3 = null;
            try {
                object3 = DbManager.getDbConnection();
                DbManager.upsertObject((Connection)object3, IdentityPrincipal.class, this.authConfig.DbSchema, this.authConfig.DbTableUsers, identityPrincipal);
                DbManager.upsertObjects((Connection)object3, IdentityGrants.class, this.authConfig.DbSchema, this.authConfig.DbTableUserGrants, object);
                object3.commit();
                this.loadData();
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error creating new user: " + exception.getMessage(), exception);
            }
            finally {
                DbManager.freeDbConnection((Connection)object3);
            }
        }
    }
}

