/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebContent;
import au.com.nemmco.Util.WebHelper;
import au.com.nemmco.Util.WebHttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient {
    private static Logger logger = LoggerFactory.getLogger(WebClient.class);
    private Proxy itsProxy;
    private Integer itsTimeoutConnectionSecs;
    private Integer itsTimeoutTransferSecs;
    private boolean itsUseHTTPS;
    private UUID itsUUID;

    public WebClient(Integer n2, Integer n3) {
        this.itsTimeoutConnectionSecs = n2;
        this.itsTimeoutTransferSecs = n3;
        this.itsUseHTTPS = false;
    }

    public WebClient(Proxy proxy, Integer n2, Integer n3) {
        this(n2, n3);
        this.itsProxy = proxy;
    }

    public WebClient(String string, Integer n2, Integer n3, Integer n4) {
        this(n3, n4);
        if (!Util.isBlank(string)) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, (int)n2);
            this.itsProxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
        }
    }

    public UUID getUUID() {
        return this.itsUUID;
    }

    public void setUUID(UUID uUID) {
        this.itsUUID = uUID;
    }

    public HttpURLConnection getHttpURLConnection(String string, URL uRL) throws ApplicationException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.itsProxy == null ? (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)uRL.openConnection(this.itsProxy);
            httpURLConnection.setRequestMethod(string);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(string.equalsIgnoreCase("POST") || string.equalsIgnoreCase("PUT"));
            if (this.itsTimeoutConnectionSecs != null) {
                httpURLConnection.setConnectTimeout(this.itsTimeoutConnectionSecs * 1000);
            }
            if (this.itsTimeoutTransferSecs != null) {
                httpURLConnection.setReadTimeout(this.itsTimeoutTransferSecs * 1000);
            }
            httpURLConnection.setUseCaches(false);
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.error(logger, "Error connecting to HTTP URL " + uRL.toString() + ": " + exception.getMessage(), exception);
        }
        return httpURLConnection;
    }

    public WebHttpResponse readResponse(HttpURLConnection httpURLConnection) throws IOException {
        WebHttpResponse webHttpResponse = new WebHttpResponse();
        webHttpResponse.ReturnCode = httpURLConnection.getResponseCode();
        if (!Util.isBlank(httpURLConnection.getContentType())) {
            webHttpResponse.ContentType = new String(httpURLConnection.getContentType());
        }
        if (httpURLConnection.getResponseCode() == 200) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));){
            webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
        }
        if (Util.isBlank(webHttpResponse.Body)) {
            webHttpResponse.Body = httpURLConnection.getResponseMessage();
        }
        return webHttpResponse;
    }

    private void signRequest(HttpURLConnection httpURLConnection, String string, URL uRL, String string2) throws Exception {
        if (!Util.isBlank(string)) {
            long l2 = new Date().getTime();
            String string3 = WebHelper.signRequest(string, uRL, string2, l2);
            httpURLConnection.setRequestProperty("AUTHORIZATION", "HMAC " + string3);
            httpURLConnection.setRequestProperty("X-TIMESTAMP", Long.toString(l2));
            if (this.itsUUID != null) {
                httpURLConnection.setRequestProperty("X-UUID", this.itsUUID.toString());
            }
        }
    }

    public WebHttpResponse doGet(URL uRL, String string) throws ApplicationException {
        WebHttpResponse webHttpResponse = new WebHttpResponse();
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.getHttpURLConnection("GET", uRL);
            this.signRequest(httpURLConnection, string, uRL, null);
            httpURLConnection.connect();
            webHttpResponse = this.readResponse(httpURLConnection);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring HTTP request from " + uRL + ": " + exception.getMessage(), exception);
        }
        return webHttpResponse;
    }

    public WebHttpResponse doPost(URL uRL, String string, WebContent.MediaType mediaType, String string2) throws ApplicationException {
        WebHttpResponse webHttpResponse = new WebHttpResponse();
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.getHttpURLConnection("POST", uRL);
            this.signRequest(httpURLConnection, string, uRL, string2);
            httpURLConnection.setRequestProperty("Content-Type", mediaType.toString().replace('_', '/'));
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string2.length()));
            httpURLConnection.getOutputStream().write(string2.getBytes());
            httpURLConnection.connect();
            webHttpResponse = this.readResponse(httpURLConnection);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring HTTP request from " + uRL + ": " + exception.getMessage(), exception);
        }
        return webHttpResponse;
    }
}

