/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebContent;
import au.com.nemmco.Util.WebGET;
import au.com.nemmco.Util.WebHandlerAPIWrapperMethod;
import au.com.nemmco.Util.WebPOST;
import au.com.nemmco.Util.WebPath;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHandlerAPIWrapper {
    private static Logger logger = LoggerFactory.getLogger(WebHandlerAPIWrapper.class);
    protected Class Handler;
    public Field fieldURL;
    public Field fieldParams;
    public Field fieldUUID;
    public Field fieldSessionKey;
    private Map<String, WebHandlerAPIWrapperMethod> getMethods = new HashMap<String, WebHandlerAPIWrapperMethod>();
    private Map<String, WebHandlerAPIWrapperMethod> postMethods = new HashMap<String, WebHandlerAPIWrapperMethod>();

    public WebHandlerAPIWrapper(Class clazz) {
        Object object;
        Object object2;
        String string = "";
        if (clazz.isAnnotationPresent(WebPath.class)) {
            object2 = clazz.getAnnotation(WebPath.class);
            object = (WebPath)object2;
            string = object.value();
        }
        object2 = clazz.getDeclaredMethods();
        object = object2;
        int n2 = ((Method[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            WebContent webContent;
            WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod;
            Object object3;
            Object object4 = object[i2];
            if (((AccessibleObject)object4).isAnnotationPresent(WebGET.class)) {
                object3 = ((Method)object4).getAnnotation(WebGET.class);
                webHandlerAPIWrapperMethod = new WebHandlerAPIWrapperMethod();
                webHandlerAPIWrapperMethod.setPath(this.concatPath(string, object3.Path()));
                if (((Method)object4).getParameterCount() == webHandlerAPIWrapperMethod.ParamNames.size()) {
                    webHandlerAPIWrapperMethod.auth = object3.Authentication();
                    webHandlerAPIWrapperMethod.AuthContext = object3.AuthContext();
                    webHandlerAPIWrapperMethod.AdminAccessOnly = object3.AdminAccessOnly();
                    webHandlerAPIWrapperMethod.action = object3.Action();
                    webHandlerAPIWrapperMethod.method = object4;
                    if (((AccessibleObject)object4).isAnnotationPresent(WebContent.class)) {
                        webContent = ((Method)object4).getAnnotation(WebContent.class);
                        webHandlerAPIWrapperMethod.contentType = webContent.value().toString();
                    }
                    if (this.getMethods.put(webHandlerAPIWrapperMethod.path, webHandlerAPIWrapperMethod) != null) {
                        Util_Logger.errorNoRaise(logger, "Detected duplicate GET path " + webHandlerAPIWrapperMethod.path + " in web handler " + clazz.getName());
                    }
                } else {
                    Util_Logger.warning(logger, "Detected mismatched parameter count for GET path " + webHandlerAPIWrapperMethod.path + " in web handler " + clazz.getName());
                }
            }
            if (!((AccessibleObject)object4).isAnnotationPresent(WebPOST.class)) continue;
            object3 = ((Method)object4).getAnnotation(WebPOST.class);
            webHandlerAPIWrapperMethod = new WebHandlerAPIWrapperMethod();
            webHandlerAPIWrapperMethod.setPath(this.concatPath(string, object3.Path()));
            webHandlerAPIWrapperMethod.auth = object3.Authentication();
            webHandlerAPIWrapperMethod.AuthContext = object3.AuthContext();
            webHandlerAPIWrapperMethod.AdminAccessOnly = object3.AdminAccessOnly();
            webHandlerAPIWrapperMethod.action = object3.Action();
            webHandlerAPIWrapperMethod.method = object4;
            if (((AccessibleObject)object4).isAnnotationPresent(WebContent.class)) {
                WebContent webContent2 = webContent = ((Method)object4).getAnnotation(WebContent.class);
                webHandlerAPIWrapperMethod.contentType = webContent2.value().toString();
            }
            if (this.postMethods.put(webHandlerAPIWrapperMethod.path, webHandlerAPIWrapperMethod) == null) continue;
            Util_Logger.errorNoRaise(logger, "Detected duplicate POST path " + webHandlerAPIWrapperMethod.path + " in web handler " + clazz.getName());
        }
        if (this.getMethods.size() > 0 || this.postMethods.size() > 0) {
            for (Object object3 : object = clazz.getDeclaredFields()) {
                if (((Field)object3).getName().equalsIgnoreCase("URL")) {
                    if (((Field)object3).getType().equals(String.class)) {
                        this.fieldURL = object3;
                        continue;
                    }
                    Util_Logger.warning(logger, "Detected field URL is class " + ((Field)object3).getType().getName() + " is not assignable from String, skipping URL variable injection");
                    continue;
                }
                if (((Field)object3).getName().equalsIgnoreCase("Params")) {
                    if (((Field)object3).getType().equals(Map.class)) {
                        this.fieldParams = object3;
                        continue;
                    }
                    Util_Logger.warning(logger, "Detected field Params in class " + ((Field)object3).getType().getName() + " is not assignable from Map, skipping Params variable injection");
                    continue;
                }
                if (((Field)object3).getName().equalsIgnoreCase("UUID")) {
                    if (((Field)object3).getType().equals(String.class)) {
                        this.fieldUUID = object3;
                        continue;
                    }
                    Util_Logger.warning(logger, "Detected field UUID in class " + ((Field)object3).getType().getName() + " is not assignable from String, skipping UUID variable injection");
                    continue;
                }
                if (!((Field)object3).getName().equalsIgnoreCase("SessionKey")) continue;
                if (((Field)object3).getType().equals(String.class)) {
                    this.fieldSessionKey = object3;
                    continue;
                }
                Util_Logger.warning(logger, "Detected field SessionKey in class " + ((Field)object3).getType().getName() + " is not assignable from String, skipping SessionKey variable injection");
            }
            this.Handler = clazz;
        } else {
            Util_Logger.errorNoRaise(logger, "Error registering handler " + clazz.getName() + ", no GET or POST methods detected");
        }
    }

    private String concatPath(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Util.isBlank(string)) {
            stringBuilder.append(string);
        }
        if (!Util.isBlank(string2)) {
            if (!(stringBuilder.isEmpty() || string.endsWith("/") || string2.startsWith("/"))) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public List<WebHandlerAPIWrapperMethod> getMethods(String string) {
        if (string.equalsIgnoreCase("GET")) {
            return new ArrayList<WebHandlerAPIWrapperMethod>(this.getMethods.values());
        }
        if (string.equalsIgnoreCase("POST")) {
            return new ArrayList<WebHandlerAPIWrapperMethod>(this.postMethods.values());
        }
        return null;
    }
}

