/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebHttpResponse;
import au.com.nemmco.Util.WebRequestConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHelper {
    private static Logger logger = LoggerFactory.getLogger(WebHelper.class);
    private static final int TIMEOUT_CONNECTION_SECONDS = 10;
    private static final int TIMEOUT_READ_SECONDS = 10;

    public static Map<String, String> queryStringToMap(String string) throws UnsupportedEncodingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!Util.isBlank(string)) {
            String string2 = URLDecoder.decode(string, "UTF-8");
            for (String string3 : string2.split("&")) {
                String[] stringArray = string3.split("=");
                if (stringArray.length > 1) {
                    hashMap.put(stringArray[0], stringArray[1]);
                    continue;
                }
                hashMap.put(stringArray[0], "");
            }
        }
        return hashMap;
    }

    public static String signRequest(String string, URL uRL, String string2, long l2) throws Exception {
        String string3 = null;
        if (!Util.isBlank(string)) {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(), "HmacSHA256");
            mac.init(secretKeySpec);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(uRL.toString());
            stringBuilder.append("~");
            stringBuilder.append(l2);
            if (!Util.isBlank(string2)) {
                stringBuilder.append("~");
                stringBuilder.append(string2);
            }
            byte[] byArray = mac.doFinal(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
            string3 = Base64.getEncoder().encodeToString(byArray);
        }
        return string3;
    }

    public static HttpURLConnection getHttpURLConnection(URL uRL, String string) throws ApplicationException {
        return WebHelper.getHttpURLConnection(uRL, string, 10, 10, null);
    }

    public static HttpURLConnection getHttpURLConnection(URL uRL, String string, WebRequestConfig webRequestConfig) throws ApplicationException {
        return WebHelper.getHttpURLConnection(uRL, string, 10, 10, webRequestConfig);
    }

    public static HttpURLConnection getHttpURLConnection(URL uRL, String string, int n2, int n3, WebRequestConfig webRequestConfig) throws ApplicationException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY);
            httpURLConnection.setRequestMethod(string);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(string.equalsIgnoreCase("POST"));
            httpURLConnection.setConnectTimeout(n2 * 1000);
            httpURLConnection.setReadTimeout(n3 * 1000);
            httpURLConnection.setUseCaches(false);
            if (webRequestConfig != null) {
                webRequestConfig.configure(httpURLConnection);
            }
            Util_Logger.debug(logger, "HTTP request to: " + uRL.toString());
            httpURLConnection.connect();
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.error(logger, "Error connecting to HTTP URL " + uRL.toString() + ": " + exception.getMessage(), exception);
        }
        return httpURLConnection;
    }

    public static WebHttpResponse readResponse(HttpURLConnection httpURLConnection) throws IOException {
        WebHttpResponse webHttpResponse = new WebHttpResponse();
        webHttpResponse.ReturnCode = httpURLConnection.getResponseCode();
        if (!Util.isBlank(httpURLConnection.getContentType())) {
            webHttpResponse.ContentType = new String(httpURLConnection.getContentType());
        }
        if (httpURLConnection.getResponseCode() == 200) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));){
            webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
        }
        if (Util.isBlank(webHttpResponse.Body)) {
            webHttpResponse.Body = httpURLConnection.getResponseMessage();
        }
        Util_Logger.debug(logger, "HTTP response body: " + webHttpResponse.Body);
        return webHttpResponse;
    }
}

