/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.AuthenticationManager;
import au.com.nemmco.Util.Crypt;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebAccessEnum;
import au.com.nemmco.Util.WebGET;
import au.com.nemmco.Util.WebHandlerAPI;
import au.com.nemmco.Util.WebHandlerAPIWrapper;
import au.com.nemmco.Util.WebHandlerDocument;
import au.com.nemmco.Util.WebPOST;
import au.com.nemmco.Util.WebServerConfig;
import au.com.nemmco.Util.WebServerConfigHTTPS;
import au.com.nemmco.Util.WebServerConfigIPAddress;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String API_KEY_HEADER_NAME = "API_KEY";
    public static final String HTTP_HEADER_TIMESTAMP = "X-TIMESTAMP";
    public static final String HTTP_HEADER_AUTHORIZATION = "AUTHORIZATION";
    public static final String HTTP_HEADER_UUID = "X-UUID";
    private static Logger logger = LoggerFactory.getLogger(WebServer.class);
    private HttpServer server;
    public Map<String, WebHandlerAPIWrapper> itsHandlers = new HashMap<String, WebHandlerAPIWrapper>();
    private boolean itsIsEnabled = false;
    private WebServerConfig itsConfig;

    private WebServer() {
    }

    public static WebServer getInstance() {
        return SingletonHolder.instance;
    }

    public void addHandler(Class clazz) {
        if (!this.itsHandlers.containsKey(clazz.getName())) {
            this.itsHandlers.put(clazz.getName(), new WebHandlerAPIWrapper(clazz));
            Util_Logger.debug(logger, "Registered Web Server API handler " + clazz.getName());
        }
    }

    public void addHandlersFromPackage(String string) {
        try {
            Util_Logger.info(logger, "Scanning classes from " + string + " to auto-detect web handlers");
            try (ScanResult scanResult = new ClassGraph().verbose(false).enableAllInfo().acceptPackages(new String[]{string}).scan();){
                for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(WebGET.class.getName())) {
                    try {
                        this.addHandler(Class.forName(classInfo.getName()));
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error registering web handler " + classInfo.getName() + ": " + exception.getMessage(), exception);
                    }
                }
                for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(WebPOST.class.getName())) {
                    try {
                        this.addHandler(Class.forName(classInfo.getName()));
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error registering web handler " + classInfo.getName() + ": " + exception.getMessage(), exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error auto-detecting web handlers: " + exception.getMessage(), exception);
        }
    }

    protected List<WebHandlerAPIWrapper> getHandlers() {
        return new ArrayList<WebHandlerAPIWrapper>(this.itsHandlers.values());
    }

    public WebServerConfig getConfig() {
        return this.itsConfig;
    }

    public static WebServerConfig loadConfigFromProperties(Properties properties) {
        Object object;
        Object object2;
        String string;
        String string2;
        WebServerConfig webServerConfig = new WebServerConfig();
        String string3 = Util.getProperty(properties, "web_server_https_keystore_file", null);
        if (!Util.isBlank(string3)) {
            webServerConfig.HTTPS = new WebServerConfigHTTPS();
            webServerConfig.HTTPS.KeyStoreFile = string3;
            webServerConfig.HTTPS.KeyStoreType = Util.getProperty(properties, "web_server_https_keystore_type", null);
            webServerConfig.HTTPS.StorePassword = Util.getProperty(properties, "web_server_https_store_password", null);
            webServerConfig.HTTPS.KeyPassword = Util.getProperty(properties, "web_server_https_key_password", null);
            webServerConfig.HTTPS.Protocol = Util.getProperty(properties, "web_server_https_protocol", "TLS");
        }
        if (Util.isInteger(string2 = Util.getProperty(properties, "web_server_port", null))) {
            webServerConfig.Port = Integer.parseInt(string2);
        } else {
            Util_Logger.warning(logger, "Missing or invalid parameter web_server_port for API access web server");
        }
        String string4 = Crypt.getInstance().getSeed();
        boolean bl = Util.getProperty(properties, "web_server_enable_authentication", "true").equalsIgnoreCase("true");
        if (bl) {
            webServerConfig.API_KEY = Util.getProperty(properties, "web_server_api_key", string4);
        }
        webServerConfig.WWW_Root = Util.getProperty(properties, "web_server_root_dir", null);
        webServerConfig.WWW_Index = Util.getProperty(properties, "web_server_index_file", null);
        webServerConfig.WebDocumentEnableCache = Util.getProperty(properties, "web_server_enable_cache", "true").equalsIgnoreCase("true");
        webServerConfig.WebDocumentEnableSSI = Util.getProperty(properties, "web_server_enable_SSI", "true").equalsIgnoreCase("true");
        webServerConfig.WebServiceCatalogEnable = Util.getProperty(properties, "web_server_enable_catalog", "true").equalsIgnoreCase("true");
        String string5 = Util.getProperty(properties, "web_server_no_threads", null);
        if (!Util.isBlank(string5)) {
            webServerConfig.NoThreads = Integer.valueOf(string5);
        }
        webServerConfig.ResponseHeaders = Util.getProperty(properties, "web_server_response_headers", null);
        String string6 = Util.getProperty(properties, "web_server_time_drift_tolerance_seconds", "60");
        if (Util.isInteger(string6)) {
            webServerConfig.TimeDriftToleranceSeconds = Integer.valueOf(string6);
        }
        if (!Util.isBlank(string = Util.getProperty(properties, "web_server_host_allow", null)) && (object2 = string.split(",")) != null) {
            object = object2;
            int n2 = ((String[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = object[i2];
                if (Util.isBlank((String)object3)) continue;
                Object object4 = new WebServerConfigIPAddress();
                ((WebServerConfigIPAddress)object4).Address = object3;
                ((WebServerConfigIPAddress)object4).Access = WebAccessEnum.ALLOW;
                webServerConfig.Hosts.add((WebServerConfigIPAddress)object4);
            }
        }
        if (!Util.isBlank((String)(object2 = Util.getProperty(properties, "web_server_host_deny", null))) && (object = ((String)object2).split(",")) != null) {
            for (Object object4 : object) {
                if (Util.isBlank((String)object4)) continue;
                WebServerConfigIPAddress webServerConfigIPAddress = new WebServerConfigIPAddress();
                webServerConfigIPAddress.Address = object4;
                webServerConfigIPAddress.Access = WebAccessEnum.DENY;
                webServerConfig.Hosts.add(webServerConfigIPAddress);
            }
        }
        return webServerConfig;
    }

    public void init(WebServerConfig webServerConfig) throws IOException {
        if (webServerConfig != null) {
            if (webServerConfig.Port > 0) {
                this.itsConfig = webServerConfig;
                this.itsIsEnabled = true;
            }
            if (!Util.isBlank(webServerConfig.WWW_Root)) {
                webServerConfig.WWW_Root = new File(webServerConfig.WWW_Root).getCanonicalFile().getPath();
            }
        }
    }

    private SSLContext getSslContext() throws Exception {
        if (this.itsConfig.HTTPS == null) {
            throw new Exception("HTTPS parameters must be defined for HTTPS protocol");
        }
        if (Util.isBlank(this.itsConfig.HTTPS.KeyStoreFile)) {
            throw new Exception("Key store file must be defined for HTTPS protocol");
        }
        if (Util.isBlank(this.itsConfig.HTTPS.StorePassword)) {
            throw new Exception("Store password must be defined for HTTPS protocol");
        }
        if (Util.isBlank(this.itsConfig.HTTPS.KeyPassword)) {
            throw new Exception("Key password must be defined for HTTPS protocol");
        }
        SSLContext sSLContext = null;
        String string = this.itsConfig.HTTPS.KeyStoreFile;
        char[] cArray = this.itsConfig.HTTPS.StorePassword.toCharArray();
        char[] cArray2 = this.itsConfig.HTTPS.KeyPassword.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(Util.isBlank(this.itsConfig.HTTPS.KeyStoreType, "PKCS12"));
        try (Object object = new FileInputStream(string);){
            keyStore.load((InputStream)object, cArray);
        }
        object = KeyManagerFactory.getInstance("SunX509");
        ((KeyManagerFactory)object).init(keyStore, cArray2);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        sSLContext = SSLContext.getInstance(Util.isBlank(this.itsConfig.HTTPS.Protocol, "TLS"));
        sSLContext.init(((KeyManagerFactory)object).getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    public void start() throws ApplicationException {
        try {
            if (this.itsIsEnabled) {
                Object object;
                Util_Logger.info(logger, "Starting web server for API access");
                HttpServer httpServer = null;
                if (this.itsConfig.getHttpProtocol()) {
                    httpServer = HttpServer.create(new InetSocketAddress(this.itsConfig.Port), 0);
                } else {
                    object = this.getSslContext();
                    httpServer = HttpsServer.create(new InetSocketAddress(this.itsConfig.Port), 0);
                    ((HttpsServer)httpServer).setHttpsConfigurator(new HttpsConfigurator((SSLContext)object){

                        @Override
                        public void configure(HttpsParameters httpsParameters) {
                            try {
                                SSLContext sSLContext = this.getSSLContext();
                                SSLEngine sSLEngine = sSLContext.createSSLEngine();
                                httpsParameters.setNeedClientAuth(false);
                                httpsParameters.setCipherSuites(sSLEngine.getEnabledCipherSuites());
                                httpsParameters.setProtocols(sSLEngine.getEnabledProtocols());
                                SSLParameters sSLParameters = sSLContext.getSupportedSSLParameters();
                                httpsParameters.setSSLParameters(sSLParameters);
                            }
                            catch (Exception exception) {
                                System.out.println("Failed to create HTTPS port");
                            }
                        }
                    });
                }
                httpServer.createContext("/api", new WebHandlerAPI());
                httpServer.createContext("/", new WebHandlerDocument());
                if (this.itsConfig.NoThreads != null) {
                    object = Executors.newFixedThreadPool(this.itsConfig.NoThreads, new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable runnable) {
                            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                            thread.setDaemon(true);
                            return thread;
                        }
                    });
                    httpServer.setExecutor((Executor)object);
                } else {
                    httpServer.setExecutor(null);
                }
                httpServer.start();
                object = this.itsConfig.getHttpProtocol() ? "http" : "https";
                Util_Logger.info(logger, "Started web server on URI " + (String)object + "://" + this.getHostName() + ":" + this.itsConfig.Port);
                AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
                if (authenticationManager.isEnabled()) {
                    Util_Logger.info(logger, "Web Server access is secured by " + authenticationManager.getProviderId() + " provider");
                } else if (Util.isBlank(this.itsConfig.API_KEY)) {
                    Util_Logger.warning(logger, "Web Server API key is not defined, access is insecure");
                } else {
                    Util_Logger.info(logger, "Web Server API key is " + this.itsConfig.API_KEY);
                }
                if (!Util.isBlank(this.itsConfig.WWW_Root) && !Util.isBlank(this.itsConfig.WWW_Index)) {
                    Util_Logger.info(logger, "Web browser interfaces available at URL " + (String)object + "://" + this.getHostName() + ":" + this.itsConfig.Port + this.itsConfig.WWW_Index);
                }
            } else {
                Util_Logger.warning(logger, "Web server for API access is disabled");
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error starting web server: " + exception.getMessage(), exception);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(1);
        }
    }

    private String getHostName() {
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static class SingletonHolder {
        private static WebServer instance = new WebServer();

        private SingletonHolder() {
        }
    }
}

