/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.WebServerConfigHTTPS;
import au.com.nemmco.Util.WebServerConfigIPAddress;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="WebServer")
public class WebServerConfig {
    public int Port;
    public String API_KEY;
    public Integer TimeDriftToleranceSeconds;
    public String WWW_Root;
    public String WWW_Index;
    public Boolean WebDocumentEnableCache;
    public Boolean WebDocumentEnableSSI;
    public Boolean WebServiceCatalogEnable;
    public Integer NoThreads;
    public String ResponseHeaders;
    public WebServerConfigHTTPS HTTPS;
    public List<WebServerConfigIPAddress> Hosts = new ArrayList<WebServerConfigIPAddress>();

    public WebServerConfig() {
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        if (this.WebDocumentEnableCache == null) {
            this.WebDocumentEnableCache = true;
        }
        if (this.WebDocumentEnableSSI == null) {
            this.WebDocumentEnableSSI = true;
        }
        if (this.NoThreads == null) {
            this.NoThreads = 5;
        }
        if (this.WebServiceCatalogEnable == null) {
            this.WebServiceCatalogEnable = true;
        }
        if (this.TimeDriftToleranceSeconds == null) {
            this.TimeDriftToleranceSeconds = 60;
        }
    }

    public boolean getHttpProtocol() {
        if (this.HTTPS == null) {
            return true;
        }
        return Util.isBlank(this.HTTPS.KeyStoreFile);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.setDefaultValues();
        return this;
    }
}

