/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.Crypt;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class netBiosCredentials {
    private static Logger logger = LoggerFactory.getLogger(netBiosCredentials.class);
    private static Properties itsConfiguration;
    private String itsHost;
    private String itsUsername;
    private String itsPassword;
    private String itsParticipantId;

    private netBiosCredentials() {
        try {
            this.itsHost = Util.getProperty(itsConfiguration, "batcher_host");
            this.itsUsername = Util.getProperty(itsConfiguration, "batcher_username");
            this.itsPassword = Util.getProperty(itsConfiguration, "batcher_password");
            boolean bl = Util.getProperty(itsConfiguration, "batcher_password_encrypted", "true").equalsIgnoreCase("true");
            if (bl) {
                Crypt crypt = Crypt.getInstance();
                this.itsPassword = crypt.decrypt(this.itsPassword);
            }
            this.itsParticipantId = Util.getProperty(itsConfiguration, "participant_identifier");
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error extracting credentials for netBios configuration: " + exception.getMessage(), exception);
        }
    }

    public static netBiosCredentials getInstance() throws ApplicationException {
        return SingletonHolder.instance;
    }

    public static void setConfiguration(Properties properties) throws ApplicationException {
        itsConfiguration = properties;
    }

    private String getDriveLetter(String string) throws ApplicationException {
        String[] stringArray = Util.getColumns(string, ':');
        return stringArray[0];
    }

    public synchronized void mapDrive(String string) {
        try {
            String string2 = this.getDriveLetter(string);
            String string3 = "cmd /c net use " + string2 + ": \\\\" + this.itsHost + "\\" + this.itsParticipantId + "$ /USER:" + this.itsUsername + " " + this.itsPassword + " /PERSISTENT:NO";
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string3);
            int n2 = process.waitFor();
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error establishing credentials to " + this.itsHost + ": " + exception.getMessage(), exception);
        }
    }

    public synchronized void disconnectDrive(String string) {
        try {
            String string2 = this.getDriveLetter(string);
            String string3 = "cmd /c net use " + string2 + ": /delete";
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string3);
            int n2 = process.waitFor();
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error disconnecting from " + this.itsHost + ": " + exception.getMessage(), exception);
        }
    }

    private static class SingletonHolder {
        private static netBiosCredentials instance = new netBiosCredentials();

        private SingletonHolder() {
        }
    }
}

