/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DLBitString;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final byte[] data;
    protected final int padBits;

    protected static int getPadBits(int bitString) {
        int n2;
        int n3 = 0;
        for (n2 = 3; n2 >= 0; --n2) {
            if (n2 != 0) {
                if (bitString >> n2 * 8 == 0) continue;
                n3 = bitString >> n2 * 8 & 0xFF;
                break;
            }
            if (bitString == 0) continue;
            n3 = bitString & 0xFF;
            break;
        }
        if (n3 == 0) {
            return 0;
        }
        n2 = 1;
        while (((n3 <<= 1) & 0xFF) != 0) {
            ++n2;
        }
        return 8 - n2;
    }

    protected static byte[] getBytes(int bitString) {
        if (bitString == 0) {
            return new byte[0];
        }
        int n2 = 4;
        for (int i2 = 3; i2 >= 1 && (bitString & 255 << i2 * 8) == 0; --i2) {
            --n2;
        }
        byte[] byArray = new byte[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            byArray[i3] = (byte)(bitString >> i3 * 8 & 0xFF);
        }
        return byArray;
    }

    public ASN1BitString(byte[] data, int padBits) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (data.length == 0 && padBits != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (padBits > 7 || padBits < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = Arrays.clone(data);
        this.padBits = padBits;
    }

    @Override
    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            stringBuffer.append(a[byArray[i2] >>> 4 & 0xF]);
            stringBuffer.append(a[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public int intValue() {
        int n2 = 0;
        byte[] byArray = this.data;
        if (this.padBits > 0 && this.data.length <= 4) {
            byArray = ASN1BitString.derForm(this.data, this.padBits);
        }
        for (int i2 = 0; i2 != byArray.length && i2 != 4; ++i2) {
            n2 |= (byArray[i2] & 0xFF) << 8 * i2;
        }
        return n2;
    }

    public byte[] getOctets() {
        if (this.padBits != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return Arrays.clone(this.data);
    }

    public byte[] getBytes() {
        return ASN1BitString.derForm(this.data, this.padBits);
    }

    public int getPadBits() {
        return this.padBits;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return this.padBits ^ Arrays.hashCode(this.getBytes());
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1BitString)) {
            return false;
        }
        ASN1BitString aSN1BitString = (ASN1BitString)o2;
        return this.padBits == aSN1BitString.padBits && Arrays.areEqual(this.getBytes(), aSN1BitString.getBytes());
    }

    protected static byte[] derForm(byte[] data, int padBits) {
        byte[] byArray = Arrays.clone(data);
        if (padBits > 0) {
            int n2 = data.length - 1;
            byArray[n2] = (byte)(byArray[n2] & 255 << padBits);
        }
        return byArray;
    }

    static ASN1BitString a(int n2, InputStream inputStream) throws IOException {
        if (n2 < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n3 = inputStream.read();
        byte[] byArray = new byte[n2 - 1];
        if (byArray.length != 0) {
            if (Streams.readFully(inputStream, byArray) != byArray.length) {
                throw new EOFException("EOF encountered in middle of BIT STRING");
            }
            if (n3 > 0 && n3 < 8 && byArray[byArray.length - 1] != (byte)(byArray[byArray.length - 1] & 255 << n3)) {
                return new DLBitString(byArray, n3);
            }
        }
        return new DERBitString(byArray, n3);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive b() {
        return new DERBitString(this.data, this.padBits);
    }

    @Override
    ASN1Primitive c() {
        return new DLBitString(this.data, this.padBits);
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;
}

