/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Properties;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1Enumerated
extends ASN1Primitive {
    private final byte[] a;
    private static ASN1Enumerated[] b = new ASN1Enumerated[12];

    public static ASN1Enumerated getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Enumerated) {
            return (ASN1Enumerated)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Enumerated)ASN1Enumerated.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Enumerated getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof ASN1Enumerated) {
            return ASN1Enumerated.getInstance(aSN1Primitive);
        }
        return ASN1Enumerated.a(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    public ASN1Enumerated(int value) {
        this.a = BigInteger.valueOf(value).toByteArray();
    }

    public ASN1Enumerated(BigInteger value) {
        this.a = value.toByteArray();
    }

    public ASN1Enumerated(byte[] bytes) {
        if (!Properties.isOverrideSet("com.enterprisedt.bouncycastle.asn1.allow_unsafe_integer") && ASN1Integer.a(bytes)) {
            throw new IllegalArgumentException("malformed enumerated");
        }
        this.a = Arrays.clone(bytes);
    }

    public BigInteger getValue() {
        return new BigInteger(this.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(10, this.a);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1Enumerated)) {
            return false;
        }
        ASN1Enumerated aSN1Enumerated = (ASN1Enumerated)o2;
        return Arrays.areEqual(this.a, aSN1Enumerated.a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    static ASN1Enumerated a(byte[] byArray) {
        if (byArray.length > 1) {
            return new ASN1Enumerated(byArray);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("ENUMERATED has zero length");
        }
        int n2 = byArray[0] & 0xFF;
        if (n2 >= b.length) {
            return new ASN1Enumerated(Arrays.clone(byArray));
        }
        ASN1Enumerated aSN1Enumerated = b[n2];
        if (aSN1Enumerated == null) {
            aSN1Enumerated = ASN1Enumerated.b[n2] = new ASN1Enumerated(Arrays.clone(byArray));
        }
        return aSN1Enumerated;
    }
}

