/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Properties;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1Primitive {
    private final byte[] a;

    public static ASN1Integer getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Integer) {
            return (ASN1Integer)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Integer)ASN1Integer.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof ASN1Integer) {
            return ASN1Integer.getInstance(aSN1Primitive);
        }
        return new ASN1Integer(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    public ASN1Integer(long value) {
        this.a = BigInteger.valueOf(value).toByteArray();
    }

    public ASN1Integer(BigInteger value) {
        this.a = value.toByteArray();
    }

    public ASN1Integer(byte[] bytes) {
        this(bytes, true);
    }

    ASN1Integer(byte[] bytes, boolean clone) {
        if (!Properties.isOverrideSet("com.enterprisedt.bouncycastle.asn1.allow_unsafe_integer") && ASN1Integer.a(bytes)) {
            throw new IllegalArgumentException("malformed integer");
        }
        this.a = clone ? Arrays.clone(bytes) : bytes;
    }

    static boolean a(byte[] byArray) {
        if (byArray.length > 1) {
            if (byArray[0] == 0 && (byArray[1] & 0x80) == 0) {
                return true;
            }
            if (byArray[0] == -1 && (byArray[1] & 0x80) != 0) {
                return true;
            }
        }
        return false;
    }

    public BigInteger getValue() {
        return new BigInteger(this.a);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(2, this.a);
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            n2 ^= (this.a[i2] & 0xFF) << i2 % 4;
        }
        return n2;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1Integer)) {
            return false;
        }
        ASN1Integer aSN1Integer = (ASN1Integer)o2;
        return Arrays.areEqual(this.a, aSN1Integer.a);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

