/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetStringParser;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BEROctetString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1OctetString
extends ASN1Primitive
implements ASN1OctetStringParser {
    byte[] a;

    public static ASN1OctetString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof ASN1OctetString) {
            return ASN1OctetString.getInstance(aSN1Primitive);
        }
        return BEROctetString.a(ASN1Sequence.getInstance(aSN1Primitive));
    }

    public static ASN1OctetString getInstance(Object obj) {
        ASN1Primitive aSN1Primitive;
        if (obj == null || obj instanceof ASN1OctetString) {
            return (ASN1OctetString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1OctetString.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct OCTET STRING from byte[]: " + iOException.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1OctetString) {
            return (ASN1OctetString)aSN1Primitive;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public ASN1OctetString(byte[] string) {
        if (string == null) {
            throw new NullPointerException("string cannot be null");
        }
        this.a = string;
    }

    @Override
    public InputStream getOctetStream() {
        return new ByteArrayInputStream(this.a);
    }

    public ASN1OctetStringParser parser() {
        return this;
    }

    public byte[] getOctets() {
        return this.a;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getOctets());
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1OctetString)) {
            return false;
        }
        ASN1OctetString aSN1OctetString = (ASN1OctetString)o2;
        return Arrays.areEqual(this.a, aSN1OctetString.a);
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive b() {
        return new DEROctetString(this.a);
    }

    @Override
    ASN1Primitive c() {
        return new DEROctetString(this.a);
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return "#" + Strings.fromByteArray(Hex.encode(this.a));
    }
}

