/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import java.io.IOException;

public abstract class ASN1Primitive
extends ASN1Object {
    ASN1Primitive() {
    }

    public static ASN1Primitive fromByteArray(byte[] data) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(data);
        try {
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            if (aSN1InputStream.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return aSN1Primitive;
        }
        catch (ClassCastException classCastException) {
            throw new IOException("cannot recognise object in stream");
        }
    }

    @Override
    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        return o2 instanceof ASN1Encodable && this.asn1Equals(((ASN1Encodable)o2).toASN1Primitive());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this;
    }

    ASN1Primitive b() {
        return this;
    }

    ASN1Primitive c() {
        return this;
    }

    @Override
    public abstract int hashCode();

    abstract boolean isConstructed();

    abstract int a() throws IOException;

    abstract void encode(ASN1OutputStream var1) throws IOException;

    abstract boolean asn1Equals(ASN1Primitive var1);
}

