/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Exception;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.BERApplicationSpecificParser;
import com.enterprisedt.bouncycastle.asn1.BEROctetStringParser;
import com.enterprisedt.bouncycastle.asn1.BERSequenceParser;
import com.enterprisedt.bouncycastle.asn1.BERSetParser;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObjectParser;
import com.enterprisedt.bouncycastle.asn1.DERApplicationSpecific;
import com.enterprisedt.bouncycastle.asn1.DERExternalParser;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DEROctetStringParser;
import com.enterprisedt.bouncycastle.asn1.DERSequenceParser;
import com.enterprisedt.bouncycastle.asn1.DERSetParser;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.InMemoryRepresentable;
import com.enterprisedt.bouncycastle.asn1.a;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.asn1.d;
import com.enterprisedt.bouncycastle.asn1.e;
import com.enterprisedt.bouncycastle.asn1.i;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream a;
    private final int b;
    private final byte[][] c;

    public ASN1StreamParser(InputStream in) {
        this(in, i.a(in));
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this.a = in;
        this.b = limit;
        this.c = new byte[11][];
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    ASN1Encodable a(int n2) throws IOException {
        switch (n2) {
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(n2));
    }

    ASN1Encodable a(boolean bl, int n2) throws IOException {
        if (this.a instanceof e) {
            if (!bl) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            return this.a(n2);
        }
        if (bl) {
            switch (n2) {
                case 17: {
                    return new DERSetParser(this);
                }
                case 16: {
                    return new DERSequenceParser(this);
                }
                case 4: {
                    return new BEROctetStringParser(this);
                }
            }
        } else {
            switch (n2) {
                case 17: {
                    throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
                }
                case 16: {
                    throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
                }
                case 4: {
                    return new DEROctetStringParser((d)this.a);
                }
            }
        }
        throw new ASN1Exception("implicit tagging not implemented");
    }

    ASN1Primitive b(boolean bl, int n2) throws IOException {
        if (!bl) {
            d d2 = (d)this.a;
            return new DERTaggedObject(false, n2, new DEROctetString(d2.b()));
        }
        ASN1EncodableVector aSN1EncodableVector = this.a();
        if (this.a instanceof e) {
            return aSN1EncodableVector.size() == 1 ? new BERTaggedObject(true, n2, aSN1EncodableVector.get(0)) : new BERTaggedObject(false, n2, com.enterprisedt.bouncycastle.asn1.a.a(aSN1EncodableVector));
        }
        return aSN1EncodableVector.size() == 1 ? new DERTaggedObject(true, n2, aSN1EncodableVector.get(0)) : new DERTaggedObject(false, n2, com.enterprisedt.bouncycastle.asn1.c.a(aSN1EncodableVector));
    }

    public ASN1Encodable readObject() throws IOException {
        int n2 = this.a.read();
        if (n2 == -1) {
            return null;
        }
        this.a(false);
        int n3 = ASN1InputStream.a(this.a, n2);
        boolean bl = (n2 & 0x20) != 0;
        int n4 = ASN1InputStream.b(this.a, this.b);
        if (n4 < 0) {
            if (!bl) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            e e2 = new e(this.a, this.b);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(e2, this.b);
            if ((n2 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n3, aSN1StreamParser);
            }
            if ((n2 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n3, aSN1StreamParser);
            }
            return aSN1StreamParser.a(n3);
        }
        d d2 = new d(this.a, n4);
        if ((n2 & 0x40) != 0) {
            return new DERApplicationSpecific(bl, n3, d2.b());
        }
        if ((n2 & 0x80) != 0) {
            return new BERTaggedObjectParser(bl, n3, new ASN1StreamParser(d2));
        }
        if (bl) {
            switch (n3) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(d2));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(d2));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(d2));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(d2));
                }
            }
            throw new IOException("unknown tag " + n3 + " encountered");
        }
        switch (n3) {
            case 4: {
                return new DEROctetStringParser(d2);
            }
        }
        try {
            return ASN1InputStream.a(n3, d2, this.c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    private void a(boolean bl) {
        if (this.a instanceof e) {
            ((e)this.a).a(bl);
        }
    }

    ASN1EncodableVector a() throws IOException {
        ASN1Encodable aSN1Encodable;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Encodable = this.readObject()) != null) {
            if (aSN1Encodable instanceof InMemoryRepresentable) {
                aSN1EncodableVector.add(((InMemoryRepresentable)((Object)aSN1Encodable)).getLoadedObject());
                continue;
            }
            aSN1EncodableVector.add(aSN1Encodable.toASN1Primitive());
        }
        return aSN1EncodableVector;
    }
}

