/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class DERBMPString
extends ASN1Primitive
implements ASN1String {
    private final char[] a;

    public static DERBMPString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBMPString) {
            return (DERBMPString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERBMPString)DERBMPString.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DERBMPString) {
            return DERBMPString.getInstance(aSN1Primitive);
        }
        return new DERBMPString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    DERBMPString(byte[] string) {
        char[] cArray = new char[string.length / 2];
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            cArray[i2] = (char)(string[2 * i2] << 8 | string[2 * i2 + 1] & 0xFF);
        }
        this.a = cArray;
    }

    DERBMPString(char[] string) {
        this.a = string;
    }

    public DERBMPString(String string) {
        this.a = string.toCharArray();
    }

    @Override
    public String getString() {
        return new String(this.a);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERBMPString)) {
            return false;
        }
        DERBMPString dERBMPString = (DERBMPString)o2;
        return Arrays.areEqual(this.a, dERBMPString.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.a.length * 2) + this.a.length * 2;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.b(30);
        out.a(this.a.length * 2);
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            char c2 = this.a[i2];
            out.b((byte)(c2 >> 8));
            out.b((byte)c2);
        }
    }
}

