/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERExternal
extends ASN1Primitive {
    private ASN1ObjectIdentifier a;
    private ASN1Integer b;
    private ASN1Primitive c;
    private int d;
    private ASN1Primitive e;

    public DERExternal(ASN1EncodableVector vector) {
        int n2 = 0;
        ASN1Primitive aSN1Primitive = this.a(vector, n2);
        if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            this.a = (ASN1ObjectIdentifier)aSN1Primitive;
            aSN1Primitive = this.a(vector, ++n2);
        }
        if (aSN1Primitive instanceof ASN1Integer) {
            this.b = (ASN1Integer)aSN1Primitive;
            aSN1Primitive = this.a(vector, ++n2);
        }
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            this.c = aSN1Primitive;
            aSN1Primitive = this.a(vector, ++n2);
        }
        if (vector.size() != n2 + 1) {
            throw new IllegalArgumentException("input vector too large");
        }
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in vector. Structure doesn't seem to be of type External");
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
        this.a(aSN1TaggedObject.getTagNo());
        this.e = aSN1TaggedObject.getObject();
    }

    private ASN1Primitive a(ASN1EncodableVector aSN1EncodableVector, int n2) {
        if (aSN1EncodableVector.size() <= n2) {
            throw new IllegalArgumentException("too few objects in input vector");
        }
        return aSN1EncodableVector.get(n2).toASN1Primitive();
    }

    public DERExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, DERTaggedObject externalData) {
        this(directReference, indirectReference, dataValueDescriptor, externalData.getTagNo(), externalData.toASN1Primitive());
    }

    public DERExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, int encoding, ASN1Primitive externalData) {
        this.a(directReference);
        this.a(indirectReference);
        this.a(dataValueDescriptor);
        this.a(encoding);
        this.b(externalData.toASN1Primitive());
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        if (this.a != null) {
            n2 = this.a.hashCode();
        }
        if (this.b != null) {
            n2 ^= this.b.hashCode();
        }
        if (this.c != null) {
            n2 ^= this.c.hashCode();
        }
        return n2 ^= this.e.hashCode();
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    int a() throws IOException {
        return this.getEncoded().length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.a != null) {
            byteArrayOutputStream.write(this.a.getEncoded("DER"));
        }
        if (this.b != null) {
            byteArrayOutputStream.write(this.b.getEncoded("DER"));
        }
        if (this.c != null) {
            byteArrayOutputStream.write(this.c.getEncoded("DER"));
        }
        DERTaggedObject dERTaggedObject = new DERTaggedObject(true, this.d, this.e);
        byteArrayOutputStream.write(dERTaggedObject.getEncoded("DER"));
        out.a(32, 8, byteArrayOutputStream.toByteArray());
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERExternal)) {
            return false;
        }
        if (this == o2) {
            return true;
        }
        DERExternal dERExternal = (DERExternal)o2;
        if (!(this.a == null || dERExternal.a != null && dERExternal.a.equals(this.a))) {
            return false;
        }
        if (!(this.b == null || dERExternal.b != null && dERExternal.b.equals(this.b))) {
            return false;
        }
        if (!(this.c == null || dERExternal.c != null && dERExternal.c.equals(this.c))) {
            return false;
        }
        return this.e.equals(dERExternal.e);
    }

    public ASN1Primitive getDataValueDescriptor() {
        return this.c;
    }

    public ASN1ObjectIdentifier getDirectReference() {
        return this.a;
    }

    public int getEncoding() {
        return this.d;
    }

    public ASN1Primitive getExternalContent() {
        return this.e;
    }

    public ASN1Integer getIndirectReference() {
        return this.b;
    }

    private void a(ASN1Primitive aSN1Primitive) {
        this.c = aSN1Primitive;
    }

    private void a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.a = aSN1ObjectIdentifier;
    }

    private void a(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + n2);
        }
        this.d = n2;
    }

    private void b(ASN1Primitive aSN1Primitive) {
        this.e = aSN1Primitive;
    }

    private void a(ASN1Integer aSN1Integer) {
        this.b = aSN1Integer;
    }
}

