/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public class DERIA5String
extends ASN1Primitive
implements ASN1String {
    private final byte[] a;

    public static DERIA5String getInstance(Object obj) {
        if (obj == null || obj instanceof DERIA5String) {
            return (DERIA5String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERIA5String)DERIA5String.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERIA5String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DERIA5String) {
            return DERIA5String.getInstance(aSN1Primitive);
        }
        return new DERIA5String(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    DERIA5String(byte[] string) {
        this.a = string;
    }

    public DERIA5String(String string) {
        this(string, false);
    }

    public DERIA5String(String string, boolean validate) {
        if (string == null) {
            throw new NullPointerException("string cannot be null");
        }
        if (validate && !DERIA5String.isIA5String(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.a = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.a);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(22, this.a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERIA5String)) {
            return false;
        }
        DERIA5String dERIA5String = (DERIA5String)o2;
        return Arrays.areEqual(this.a, dERIA5String.a);
    }

    public static boolean isIA5String(String str) {
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            char c2 = str.charAt(i2);
            if (c2 <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

