/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERT61String;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public class DERT61UTF8String
extends ASN1Primitive
implements ASN1String {
    private byte[] a;

    public static DERT61UTF8String getInstance(Object obj) {
        if (obj instanceof DERT61String) {
            return new DERT61UTF8String(((DERT61String)obj).getOctets());
        }
        if (obj == null || obj instanceof DERT61UTF8String) {
            return (DERT61UTF8String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new DERT61UTF8String(((DERT61String)DERT61UTF8String.fromByteArray((byte[])obj)).getOctets());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERT61UTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DERT61String || aSN1Primitive instanceof DERT61UTF8String) {
            return DERT61UTF8String.getInstance(aSN1Primitive);
        }
        return new DERT61UTF8String(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    public DERT61UTF8String(byte[] string) {
        this.a = string;
    }

    public DERT61UTF8String(String string) {
        this(Strings.toUTF8ByteArray(string));
    }

    @Override
    public String getString() {
        return Strings.fromUTF8ByteArray(this.a);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(20, this.a);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.a);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERT61UTF8String)) {
            return false;
        }
        return Arrays.areEqual(this.a, ((DERT61UTF8String)o2).a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }
}

