/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUniversalString
extends ASN1Primitive
implements ASN1String {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] b;

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERUniversalString)DERUniversalString.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DERUniversalString) {
            return DERUniversalString.getInstance(aSN1Primitive);
        }
        return new DERUniversalString(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    public DERUniversalString(byte[] string) {
        this.b = Arrays.clone(string);
    }

    @Override
    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("internal error encoding UniversalString");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            stringBuffer.append(a[byArray[i2] >>> 4 & 0xF]);
            stringBuffer.append(a[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.b);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.b.length) + this.b.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(28, this.getOctets());
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERUniversalString)) {
            return false;
        }
        return Arrays.areEqual(this.b, ((DERUniversalString)o2).b);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.b);
    }
}

