/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.crmf.PKIPublicationInfo;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.Arrays;

public class CMCPublicationInfo
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final ASN1Sequence b;
    private final PKIPublicationInfo c;

    public CMCPublicationInfo(AlgorithmIdentifier hashAlg, byte[][] anchorHashes, PKIPublicationInfo pubInfo) {
        this.a = hashAlg;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != anchorHashes.length; ++i2) {
            aSN1EncodableVector.add(new DEROctetString(Arrays.clone(anchorHashes[i2])));
        }
        this.b = new DERSequence(aSN1EncodableVector);
        this.c = pubInfo;
    }

    private CMCPublicationInfo(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(seq.getObjectAt(1));
        this.c = PKIPublicationInfo.getInstance(seq.getObjectAt(2));
    }

    public static CMCPublicationInfo getInstance(Object o2) {
        if (o2 instanceof CMCPublicationInfo) {
            return (CMCPublicationInfo)o2;
        }
        if (o2 != null) {
            return new CMCPublicationInfo(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.a;
    }

    public byte[][] getCertHashes() {
        byte[][] byArrayArray = new byte[this.b.size()][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone(ASN1OctetString.getInstance(this.b.getObjectAt(i2)).getOctets());
        }
        return byArrayArray;
    }

    public PKIPublicationInfo getPubInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

