/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartID;
import com.enterprisedt.bouncycastle.asn1.cmc.CMCFailInfo;
import com.enterprisedt.bouncycastle.asn1.cmc.CMCStatus;
import com.enterprisedt.bouncycastle.asn1.cmc.PendInfo;
import com.enterprisedt.bouncycastle.asn1.cmc.a;

public class CMCStatusInfo
extends ASN1Object {
    private final CMCStatus a;
    private final ASN1Sequence b;
    private final DERUTF8String c;
    private final OtherInfo d;

    CMCStatusInfo(CMCStatus cMCStatus, ASN1Sequence bodyList, DERUTF8String statusString, OtherInfo otherInfo) {
        this.a = cMCStatus;
        this.b = bodyList;
        this.c = statusString;
        this.d = otherInfo;
    }

    private CMCStatusInfo(ASN1Sequence seq) {
        if (seq.size() < 2 || seq.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = CMCStatus.getInstance(seq.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(seq.getObjectAt(1));
        if (seq.size() > 3) {
            this.c = DERUTF8String.getInstance(seq.getObjectAt(2));
            this.d = OtherInfo.b(seq.getObjectAt(3));
        } else if (seq.size() > 2) {
            if (seq.getObjectAt(2) instanceof DERUTF8String) {
                this.c = DERUTF8String.getInstance(seq.getObjectAt(2));
                this.d = null;
            } else {
                this.c = null;
                this.d = OtherInfo.b(seq.getObjectAt(2));
            }
        } else {
            this.c = null;
            this.d = null;
        }
    }

    public static CMCStatusInfo getInstance(Object o2) {
        if (o2 instanceof CMCStatusInfo) {
            return (CMCStatusInfo)o2;
        }
        if (o2 != null) {
            return new CMCStatusInfo(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public CMCStatus getCMCStatus() {
        return this.a;
    }

    public BodyPartID[] getBodyList() {
        return com.enterprisedt.bouncycastle.asn1.cmc.a.a(this.b);
    }

    public DERUTF8String getStatusString() {
        return this.c;
    }

    public boolean hasOtherInfo() {
        return this.d != null;
    }

    public OtherInfo getOtherInfo() {
        return this.d;
    }

    public static class OtherInfo
    extends ASN1Object
    implements ASN1Choice {
        private final CMCFailInfo a;
        private final PendInfo b;

        private static OtherInfo b(Object object) {
            if (object instanceof OtherInfo) {
                return (OtherInfo)object;
            }
            if (object instanceof ASN1Encodable) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
                if (aSN1Primitive instanceof ASN1Integer) {
                    return new OtherInfo(CMCFailInfo.getInstance(aSN1Primitive));
                }
                if (aSN1Primitive instanceof ASN1Sequence) {
                    return new OtherInfo(PendInfo.getInstance(aSN1Primitive));
                }
            }
            throw new IllegalArgumentException("unknown object in getInstance(): " + object.getClass().getName());
        }

        OtherInfo(CMCFailInfo failInfo) {
            this(failInfo, null);
        }

        OtherInfo(PendInfo pendInfo) {
            this(null, pendInfo);
        }

        private OtherInfo(CMCFailInfo failInfo, PendInfo pendInfo) {
            this.a = failInfo;
            this.b = pendInfo;
        }

        public boolean isFailInfo() {
            return this.a != null;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            if (this.b != null) {
                return this.b.toASN1Primitive();
            }
            return this.a.toASN1Primitive();
        }
    }
}

