/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartPath;

public class CMCUnsignedData
extends ASN1Object {
    private final BodyPartPath a;
    private final ASN1ObjectIdentifier b;
    private final ASN1Encodable c;

    public CMCUnsignedData(BodyPartPath bodyPartPath, ASN1ObjectIdentifier identifier, ASN1Encodable content) {
        this.a = bodyPartPath;
        this.b = identifier;
        this.c = content;
    }

    private CMCUnsignedData(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartPath.getInstance(seq.getObjectAt(0));
        this.b = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(1));
        this.c = seq.getObjectAt(2);
    }

    public static CMCUnsignedData getInstance(Object o2) {
        if (o2 instanceof CMCUnsignedData) {
            return (CMCUnsignedData)o2;
        }
        if (o2 != null) {
            return new CMCUnsignedData(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    public BodyPartPath getBodyPartPath() {
        return this.a;
    }

    public ASN1ObjectIdentifier getIdentifier() {
        return this.b;
    }

    public ASN1Encodable getContent() {
        return this.c;
    }
}

