/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartReference;

public class ControlsProcessed
extends ASN1Object {
    private final ASN1Sequence a;

    public ControlsProcessed(BodyPartReference bodyPartRef) {
        this.a = new DERSequence(bodyPartRef);
    }

    public ControlsProcessed(BodyPartReference[] bodyList) {
        this.a = new DERSequence(bodyList);
    }

    public static ControlsProcessed getInstance(Object src) {
        if (src instanceof ControlsProcessed) {
            return (ControlsProcessed)src;
        }
        if (src != null) {
            return new ControlsProcessed(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    private ControlsProcessed(ASN1Sequence seq) {
        if (seq.size() != 1) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = ASN1Sequence.getInstance(seq.getObjectAt(0));
    }

    public BodyPartReference[] getBodyList() {
        BodyPartReference[] bodyPartReferenceArray = new BodyPartReference[this.a.size()];
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            bodyPartReferenceArray[i2] = BodyPartReference.getInstance(this.a.getObjectAt(i2));
        }
        return bodyPartReferenceArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.a);
    }
}

