/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.TaggedRequest;
import com.enterprisedt.bouncycastle.asn1.cms.ContentInfo;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.Arrays;

public class EncryptedPOP
extends ASN1Object {
    private final TaggedRequest a;
    private final ContentInfo b;
    private final AlgorithmIdentifier c;
    private final AlgorithmIdentifier d;
    private final byte[] e;

    private EncryptedPOP(ASN1Sequence seq) {
        if (seq.size() != 5) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = TaggedRequest.getInstance(seq.getObjectAt(0));
        this.b = ContentInfo.getInstance(seq.getObjectAt(1));
        this.c = AlgorithmIdentifier.getInstance(seq.getObjectAt(2));
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(3));
        this.e = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(4)).getOctets());
    }

    public EncryptedPOP(TaggedRequest request, ContentInfo cms, AlgorithmIdentifier thePOPAlgID, AlgorithmIdentifier witnessAlgID, byte[] witness) {
        this.a = request;
        this.b = cms;
        this.c = thePOPAlgID;
        this.d = witnessAlgID;
        this.e = Arrays.clone(witness);
    }

    public static EncryptedPOP getInstance(Object o2) {
        if (o2 instanceof EncryptedPOP) {
            return (EncryptedPOP)o2;
        }
        if (o2 != null) {
            return new EncryptedPOP(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public TaggedRequest getRequest() {
        return this.a;
    }

    public ContentInfo getCms() {
        return this.b;
    }

    public AlgorithmIdentifier getThePOPAlgID() {
        return this.c;
    }

    public AlgorithmIdentifier getWitnessAlgID() {
        return this.d;
    }

    public byte[] getWitness() {
        return Arrays.clone(this.e);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(new DEROctetString(this.e));
        return new DERSequence(aSN1EncodableVector);
    }
}

