/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;

public class ExtendedFailInfo
extends ASN1Object {
    private final ASN1ObjectIdentifier a;
    private final ASN1Encodable b;

    public ExtendedFailInfo(ASN1ObjectIdentifier failInfoOID, ASN1Encodable failInfoValue) {
        this.a = failInfoOID;
        this.b = failInfoValue;
    }

    private ExtendedFailInfo(ASN1Sequence s2) {
        if (s2.size() != 2) {
            throw new IllegalArgumentException("Sequence must be 2 elements.");
        }
        this.a = ASN1ObjectIdentifier.getInstance(s2.getObjectAt(0));
        this.b = s2.getObjectAt(1);
    }

    public static ExtendedFailInfo getInstance(Object obj) {
        if (obj instanceof ExtendedFailInfo) {
            return (ExtendedFailInfo)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Sequence) {
                return new ExtendedFailInfo((ASN1Sequence)aSN1Primitive);
            }
        } else if (obj instanceof byte[]) {
            return ExtendedFailInfo.getInstance(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.a, this.b});
    }

    public ASN1ObjectIdentifier getFailInfoOID() {
        return this.a;
    }

    public ASN1Encodable getFailInfoValue() {
        return this.b;
    }
}

