/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.ReasonFlags;

public class GetCRL
extends ASN1Object {
    private final X500Name a;
    private GeneralName b;
    private ASN1GeneralizedTime c;
    private ReasonFlags d;

    public GetCRL(X500Name issuerName, GeneralName cRLName, ASN1GeneralizedTime time, ReasonFlags reasons) {
        this.a = issuerName;
        this.b = cRLName;
        this.c = time;
        this.d = reasons;
    }

    private GetCRL(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = X500Name.getInstance(seq.getObjectAt(0));
        int n2 = 1;
        if (seq.size() > n2 && seq.getObjectAt(n2).toASN1Primitive() instanceof ASN1TaggedObject) {
            this.b = GeneralName.getInstance(seq.getObjectAt(n2++));
        }
        if (seq.size() > n2 && seq.getObjectAt(n2).toASN1Primitive() instanceof ASN1GeneralizedTime) {
            this.c = ASN1GeneralizedTime.getInstance(seq.getObjectAt(n2++));
        }
        if (seq.size() > n2 && seq.getObjectAt(n2).toASN1Primitive() instanceof DERBitString) {
            this.d = new ReasonFlags(DERBitString.getInstance(seq.getObjectAt(n2)));
        }
    }

    public static GetCRL getInstance(Object o2) {
        if (o2 instanceof GetCRL) {
            return (GetCRL)o2;
        }
        if (o2 != null) {
            return new GetCRL(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public X500Name getIssuerName() {
        return this.a;
    }

    public GeneralName getcRLName() {
        return this.b;
    }

    public ASN1GeneralizedTime getTime() {
        return this.c;
    }

    public ReasonFlags getReasons() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

