/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import java.math.BigInteger;

public class GetCert
extends ASN1Object {
    private final GeneralName a;
    private final BigInteger b;

    private GetCert(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = GeneralName.getInstance(seq.getObjectAt(0));
        this.b = ASN1Integer.getInstance(seq.getObjectAt(1)).getValue();
    }

    public GetCert(GeneralName issuerName, BigInteger serialNumber) {
        this.a = issuerName;
        this.b = serialNumber;
    }

    public static GetCert getInstance(Object o2) {
        if (o2 instanceof GetCert) {
            return (GetCert)o2;
        }
        if (o2 != null) {
            return new GetCert(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public GeneralName getIssuerName() {
        return this.a;
    }

    public BigInteger getSerialNumber() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

