/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartID;

public class LraPopWitness
extends ASN1Object {
    private final BodyPartID a;
    private final ASN1Sequence b;

    public LraPopWitness(BodyPartID pkiDataBodyid, ASN1Sequence bodyIds) {
        this.a = pkiDataBodyid;
        this.b = bodyIds;
    }

    private LraPopWitness(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartID.getInstance(seq.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(seq.getObjectAt(1));
    }

    public static LraPopWitness getInstance(Object o2) {
        if (o2 instanceof LraPopWitness) {
            return (LraPopWitness)o2;
        }
        if (o2 != null) {
            return new LraPopWitness(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public BodyPartID getPkiDataBodyid() {
        return this.a;
    }

    public BodyPartID[] getBodyIds() {
        BodyPartID[] bodyPartIDArray = new BodyPartID[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            bodyPartIDArray[i2] = BodyPartID.getInstance(this.b.getObjectAt(i2));
        }
        return bodyPartIDArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

