/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartList;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartPath;
import com.enterprisedt.bouncycastle.asn1.crmf.CertTemplate;

public class ModCertTemplate
extends ASN1Object {
    private final BodyPartPath a;
    private final BodyPartList b;
    private final boolean c;
    private final CertTemplate d;

    public ModCertTemplate(BodyPartPath pkiDataReference, BodyPartList certReferences, boolean replace, CertTemplate certTemplate) {
        this.a = pkiDataReference;
        this.b = certReferences;
        this.c = replace;
        this.d = certTemplate;
    }

    private ModCertTemplate(ASN1Sequence seq) {
        if (seq.size() != 4 && seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartPath.getInstance(seq.getObjectAt(0));
        this.b = BodyPartList.getInstance(seq.getObjectAt(1));
        if (seq.size() == 4) {
            this.c = ASN1Boolean.getInstance(seq.getObjectAt(2)).isTrue();
            this.d = CertTemplate.getInstance(seq.getObjectAt(3));
        } else {
            this.c = true;
            this.d = CertTemplate.getInstance(seq.getObjectAt(2));
        }
    }

    public static ModCertTemplate getInstance(Object o2) {
        if (o2 instanceof ModCertTemplate) {
            return (ModCertTemplate)o2;
        }
        if (o2 != null) {
            return new ModCertTemplate(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public BodyPartPath getPkiDataReference() {
        return this.a;
    }

    public BodyPartList getCertReferences() {
        return this.b;
    }

    public boolean isReplacingFields() {
        return this.c;
    }

    public CertTemplate getCertTemplate() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (!this.c) {
            aSN1EncodableVector.add(ASN1Boolean.getInstance(this.c));
        }
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

