/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.OtherMsg;
import com.enterprisedt.bouncycastle.asn1.cmc.TaggedAttribute;
import com.enterprisedt.bouncycastle.asn1.cmc.TaggedContentInfo;
import com.enterprisedt.bouncycastle.asn1.cmc.TaggedRequest;

public class PKIData
extends ASN1Object {
    private final TaggedAttribute[] a;
    private final TaggedRequest[] b;
    private final TaggedContentInfo[] c;
    private final OtherMsg[] d;

    public PKIData(TaggedAttribute[] controlSequence, TaggedRequest[] reqSequence, TaggedContentInfo[] cmsSequence, OtherMsg[] otherMsgSequence) {
        this.a = controlSequence;
        this.b = reqSequence;
        this.c = cmsSequence;
        this.d = otherMsgSequence;
    }

    private PKIData(ASN1Sequence seq) {
        int n2;
        if (seq.size() != 4) {
            throw new IllegalArgumentException("Sequence not 4 elements.");
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)seq.getObjectAt(0);
        this.a = new TaggedAttribute[aSN1Sequence.size()];
        for (n2 = 0; n2 < this.a.length; ++n2) {
            this.a[n2] = TaggedAttribute.getInstance(aSN1Sequence.getObjectAt(n2));
        }
        aSN1Sequence = (ASN1Sequence)seq.getObjectAt(1);
        this.b = new TaggedRequest[aSN1Sequence.size()];
        for (n2 = 0; n2 < this.b.length; ++n2) {
            this.b[n2] = TaggedRequest.getInstance(aSN1Sequence.getObjectAt(n2));
        }
        aSN1Sequence = (ASN1Sequence)seq.getObjectAt(2);
        this.c = new TaggedContentInfo[aSN1Sequence.size()];
        for (n2 = 0; n2 < this.c.length; ++n2) {
            this.c[n2] = TaggedContentInfo.getInstance(aSN1Sequence.getObjectAt(n2));
        }
        aSN1Sequence = (ASN1Sequence)seq.getObjectAt(3);
        this.d = new OtherMsg[aSN1Sequence.size()];
        for (n2 = 0; n2 < this.d.length; ++n2) {
            this.d[n2] = OtherMsg.getInstance(aSN1Sequence.getObjectAt(n2));
        }
    }

    public static PKIData getInstance(Object src) {
        if (src instanceof PKIData) {
            return (PKIData)src;
        }
        if (src != null) {
            return new PKIData(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{new DERSequence(this.a), new DERSequence(this.b), new DERSequence(this.c), new DERSequence(this.d)});
    }

    public TaggedAttribute[] getControlSequence() {
        return this.a;
    }

    public TaggedRequest[] getReqSequence() {
        return this.b;
    }

    public TaggedContentInfo[] getCmsSequence() {
        return this.c;
    }

    public OtherMsg[] getOtherMsgSequence() {
        return this.d;
    }
}

