/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;

public class PKIResponse
extends ASN1Object {
    private final ASN1Sequence a;
    private final ASN1Sequence b;
    private final ASN1Sequence c;

    private PKIResponse(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = ASN1Sequence.getInstance(seq.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(seq.getObjectAt(1));
        this.c = ASN1Sequence.getInstance(seq.getObjectAt(2));
    }

    public static PKIResponse getInstance(Object o2) {
        if (o2 instanceof PKIResponse) {
            return (PKIResponse)o2;
        }
        if (o2 != null) {
            return new PKIResponse(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public static PKIResponse getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIResponse.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    public ASN1Sequence getControlSequence() {
        return this.a;
    }

    public ASN1Sequence getCmsSequence() {
        return this.b;
    }

    public ASN1Sequence getOtherMsgSequence() {
        return this.c;
    }
}

