/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.CRLReason;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class RevokeRequest
extends ASN1Object {
    private final X500Name a;
    private final ASN1Integer b;
    private final CRLReason c;
    private ASN1GeneralizedTime d;
    private ASN1OctetString e;
    private DERUTF8String f;

    public RevokeRequest(X500Name name, ASN1Integer serialNumber, CRLReason reason, ASN1GeneralizedTime invalidityDate, ASN1OctetString passphrase, DERUTF8String comment) {
        this.a = name;
        this.b = serialNumber;
        this.c = reason;
        this.d = invalidityDate;
        this.e = passphrase;
        this.f = comment;
    }

    private RevokeRequest(ASN1Sequence seq) {
        if (seq.size() < 3 || seq.size() > 6) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = X500Name.getInstance(seq.getObjectAt(0));
        this.b = ASN1Integer.getInstance(seq.getObjectAt(1));
        this.c = CRLReason.getInstance(seq.getObjectAt(2));
        int n2 = 3;
        if (seq.size() > n2 && seq.getObjectAt(n2).toASN1Primitive() instanceof ASN1GeneralizedTime) {
            this.d = ASN1GeneralizedTime.getInstance(seq.getObjectAt(n2++));
        }
        if (seq.size() > n2 && seq.getObjectAt(n2).toASN1Primitive() instanceof ASN1OctetString) {
            this.e = ASN1OctetString.getInstance(seq.getObjectAt(n2++));
        }
        if (seq.size() > n2 && seq.getObjectAt(n2).toASN1Primitive() instanceof DERUTF8String) {
            this.f = DERUTF8String.getInstance(seq.getObjectAt(n2));
        }
    }

    public static RevokeRequest getInstance(Object o2) {
        if (o2 instanceof RevokeRequest) {
            return (RevokeRequest)o2;
        }
        if (o2 != null) {
            return new RevokeRequest(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public X500Name getName() {
        return this.a;
    }

    public BigInteger getSerialNumber() {
        return this.b.getValue();
    }

    public CRLReason getReason() {
        return this.c;
    }

    public ASN1GeneralizedTime getInvalidityDate() {
        return this.d;
    }

    public void setInvalidityDate(ASN1GeneralizedTime invalidityDate) {
        this.d = invalidityDate;
    }

    public ASN1OctetString getPassphrase() {
        return this.e;
    }

    public void setPassphrase(ASN1OctetString passphrase) {
        this.e = passphrase;
    }

    public DERUTF8String getComment() {
        return this.f;
    }

    public void setComment(DERUTF8String comment) {
        this.f = comment;
    }

    public byte[] getPassPhrase() {
        if (this.e != null) {
            return Arrays.clone(this.e.getOctets());
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        if (this.f != null) {
            aSN1EncodableVector.add(this.f);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

