/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartID;

public class TaggedAttribute
extends ASN1Object {
    private final BodyPartID a;
    private final ASN1ObjectIdentifier b;
    private final ASN1Set c;

    public static TaggedAttribute getInstance(Object o2) {
        if (o2 instanceof TaggedAttribute) {
            return (TaggedAttribute)o2;
        }
        if (o2 != null) {
            return new TaggedAttribute(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private TaggedAttribute(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartID.getInstance(seq.getObjectAt(0));
        this.b = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(1));
        this.c = ASN1Set.getInstance(seq.getObjectAt(2));
    }

    public TaggedAttribute(BodyPartID bodyPartID, ASN1ObjectIdentifier attrType, ASN1Set attrValues) {
        this.a = bodyPartID;
        this.b = attrType;
        this.c = attrValues;
    }

    public BodyPartID getBodyPartID() {
        return this.a;
    }

    public ASN1ObjectIdentifier getAttrType() {
        return this.b;
    }

    public ASN1Set getAttrValues() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.a, this.b, this.c});
    }
}

