/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartID;
import com.enterprisedt.bouncycastle.asn1.cms.ContentInfo;

public class TaggedContentInfo
extends ASN1Object {
    private final BodyPartID a;
    private final ContentInfo b;

    public TaggedContentInfo(BodyPartID bodyPartID, ContentInfo contentInfo) {
        this.a = bodyPartID;
        this.b = contentInfo;
    }

    private TaggedContentInfo(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartID.getInstance(seq.getObjectAt(0));
        this.b = ContentInfo.getInstance(seq.getObjectAt(1));
    }

    public static TaggedContentInfo getInstance(Object o2) {
        if (o2 instanceof TaggedContentInfo) {
            return (TaggedContentInfo)o2;
        }
        if (o2 != null) {
            return new TaggedContentInfo(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public static TaggedContentInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TaggedContentInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }

    public BodyPartID getBodyPartID() {
        return this.a;
    }

    public ContentInfo getContentInfo() {
        return this.b;
    }
}

