/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.AttributeCertificate;
import com.enterprisedt.bouncycastle.asn1.x509.Certificate;
import java.io.IOException;

public class CMPCertificate
extends ASN1Object
implements ASN1Choice {
    private Certificate a;
    private int b;
    private ASN1Object c;

    public CMPCertificate(AttributeCertificate x509v2AttrCert) {
        this(1, x509v2AttrCert);
    }

    public CMPCertificate(int type, ASN1Object otherCert) {
        this.b = type;
        this.c = otherCert;
    }

    public CMPCertificate(Certificate x509v3PKCert) {
        if (x509v3PKCert.getVersionNumber() != 3) {
            throw new IllegalArgumentException("only version 3 certificates allowed");
        }
        this.a = x509v3PKCert;
    }

    public static CMPCertificate getInstance(Object o2) {
        if (o2 == null || o2 instanceof CMPCertificate) {
            return (CMPCertificate)o2;
        }
        if (o2 instanceof byte[]) {
            try {
                o2 = ASN1Primitive.fromByteArray((byte[])o2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Invalid encoding in CMPCertificate");
            }
        }
        if (o2 instanceof ASN1Sequence) {
            return new CMPCertificate(Certificate.getInstance(o2));
        }
        if (o2 instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)o2;
            return new CMPCertificate(aSN1TaggedObject.getTagNo(), aSN1TaggedObject.getObject());
        }
        throw new IllegalArgumentException("Invalid object: " + o2.getClass().getName());
    }

    public boolean isX509v3PKCert() {
        return this.a != null;
    }

    public Certificate getX509v3PKCert() {
        return this.a;
    }

    public AttributeCertificate getX509v2AttrCert() {
        return AttributeCertificate.getInstance(this.c);
    }

    public int getOtherCertTag() {
        return this.b;
    }

    public ASN1Object getOtherCert() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.c != null) {
            return new DERTaggedObject(true, this.b, this.c);
        }
        return this.a.toASN1Primitive();
    }
}

