/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.CMPCertificate;
import com.enterprisedt.bouncycastle.asn1.crmf.EncryptedValue;

public class CertOrEncCert
extends ASN1Object
implements ASN1Choice {
    private CMPCertificate a;
    private EncryptedValue b;

    private CertOrEncCert(ASN1TaggedObject tagged) {
        if (tagged.getTagNo() == 0) {
            this.a = CMPCertificate.getInstance(tagged.getObject());
        } else if (tagged.getTagNo() == 1) {
            this.b = EncryptedValue.getInstance(tagged.getObject());
        } else {
            throw new IllegalArgumentException("unknown tag: " + tagged.getTagNo());
        }
    }

    public static CertOrEncCert getInstance(Object o2) {
        if (o2 instanceof CertOrEncCert) {
            return (CertOrEncCert)o2;
        }
        if (o2 instanceof ASN1TaggedObject) {
            return new CertOrEncCert((ASN1TaggedObject)o2);
        }
        return null;
    }

    public CertOrEncCert(CMPCertificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        this.a = certificate;
    }

    public CertOrEncCert(EncryptedValue encryptedCert) {
        if (encryptedCert == null) {
            throw new IllegalArgumentException("'encryptedCert' cannot be null");
        }
        this.b = encryptedCert;
    }

    public CMPCertificate getCertificate() {
        return this.a;
    }

    public EncryptedValue getEncryptedCert() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return new DERTaggedObject(true, 0, this.a);
        }
        return new DERTaggedObject(true, 1, this.b);
    }
}

